package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ConsoleNotificationListFluent<A extends ConsoleNotificationListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ConsoleNotification item);
    public A setToItems(int index,ConsoleNotification item);
    public A addToItems(ConsoleNotification... items);
    public A addAllToItems(Collection<ConsoleNotification> items);
    public A removeFromItems(ConsoleNotification... items);
    public A removeAllFromItems(Collection<ConsoleNotification> items);
    public A removeMatchingFromItems(Predicate<ConsoleNotificationBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ConsoleNotification> getItems();
    public List<ConsoleNotification> buildItems();
    public ConsoleNotification buildItem(int index);
    public ConsoleNotification buildFirstItem();
    public ConsoleNotification buildLastItem();
    public ConsoleNotification buildMatchingItem(Predicate<ConsoleNotificationBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ConsoleNotificationBuilder> predicate);
    public A withItems(List<ConsoleNotification> items);
    public A withItems(ConsoleNotification... items);
    public Boolean hasItems();
    public ConsoleNotificationListFluent.ItemsNested<A> addNewItem();
    public ConsoleNotificationListFluent.ItemsNested<A> addNewItemLike(ConsoleNotification item);
    public ConsoleNotificationListFluent.ItemsNested<A> setNewItemLike(int index,ConsoleNotification item);
    public ConsoleNotificationListFluent.ItemsNested<A> editItem(int index);
    public ConsoleNotificationListFluent.ItemsNested<A> editFirstItem();
    public ConsoleNotificationListFluent.ItemsNested<A> editLastItem();
    public ConsoleNotificationListFluent.ItemsNested<A> editMatchingItem(Predicate<ConsoleNotificationBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleNotificationFluent<ConsoleNotificationListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
