package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleExternalLogLinkListBuilder extends ConsoleExternalLogLinkListFluentImpl<ConsoleExternalLogLinkListBuilder> implements VisitableBuilder<ConsoleExternalLogLinkList,ConsoleExternalLogLinkListBuilder> {

    ConsoleExternalLogLinkListFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleExternalLogLinkListBuilder() { 
        this(true);
    }


    public ConsoleExternalLogLinkListBuilder(Boolean validationEnabled) { 
        this(new ConsoleExternalLogLinkList(), validationEnabled);
    }


    public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkListFluent<?> fluent) { 
        this(fluent, true);
    }


    public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ConsoleExternalLogLinkList(), validationEnabled);
    }


    public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkListFluent<?> fluent,ConsoleExternalLogLinkList instance) { 
        this(fluent, instance, true);
    }


    public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkListFluent<?> fluent,ConsoleExternalLogLinkList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkList instance) { 
        this(instance,true);
    }


    public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ConsoleExternalLogLinkList build() {
        ConsoleExternalLogLinkList buildable = new ConsoleExternalLogLinkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleExternalLogLinkListBuilder that = (ConsoleExternalLogLinkListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
