package io.fabric8.openshift.api.model.console.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.TypeMeta;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ConsoleYAMLSampleSpecFluentImpl<A extends ConsoleYAMLSampleSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConsoleYAMLSampleSpecFluent<A> {

    private String description;
    private Boolean snippet;
    private TypeMeta targetResource;
    private String title;
    private String yaml;

    public ConsoleYAMLSampleSpecFluentImpl() { 
    }


    public ConsoleYAMLSampleSpecFluentImpl(ConsoleYAMLSampleSpec instance) { 
        this.withDescription(instance.getDescription()); 
        this.withSnippet(instance.getSnippet()); 
        this.withTargetResource(instance.getTargetResource()); 
        this.withTitle(instance.getTitle()); 
        this.withYaml(instance.getYaml()); 
    }


    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description=description; return (A) this;
    }

    public Boolean hasDescription() {
        return this.description != null;
    }

    public A withNewDescription(String arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuilder arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1) {
        return (A)withDescription(new String(arg1));
    }

    public Boolean isSnippet() {
        return this.snippet;
    }

    public A withSnippet(Boolean snippet) {
        this.snippet=snippet; return (A) this;
    }

    public Boolean hasSnippet() {
        return this.snippet != null;
    }

    public A withNewSnippet(String arg1) {
        return (A)withSnippet(new Boolean(arg1));
    }

    public A withNewSnippet(boolean arg1) {
        return (A)withSnippet(new Boolean(arg1));
    }

    public TypeMeta getTargetResource() {
        return this.targetResource;
    }

    public A withTargetResource(TypeMeta targetResource) {
        this.targetResource=targetResource; return (A) this;
    }

    public Boolean hasTargetResource() {
        return this.targetResource != null;
    }

    public A withNewTargetResource(String apiVersion,String kind) {
        return (A)withTargetResource(new TypeMeta(apiVersion, kind));
    }

    public String getTitle() {
        return this.title;
    }

    public A withTitle(String title) {
        this.title=title; return (A) this;
    }

    public Boolean hasTitle() {
        return this.title != null;
    }

    public A withNewTitle(String arg1) {
        return (A)withTitle(new String(arg1));
    }

    public A withNewTitle(StringBuilder arg1) {
        return (A)withTitle(new String(arg1));
    }

    public A withNewTitle(StringBuffer arg1) {
        return (A)withTitle(new String(arg1));
    }

    public String getYaml() {
        return this.yaml;
    }

    public A withYaml(String yaml) {
        this.yaml=yaml; return (A) this;
    }

    public Boolean hasYaml() {
        return this.yaml != null;
    }

    public A withNewYaml(String arg1) {
        return (A)withYaml(new String(arg1));
    }

    public A withNewYaml(StringBuilder arg1) {
        return (A)withYaml(new String(arg1));
    }

    public A withNewYaml(StringBuffer arg1) {
        return (A)withYaml(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConsoleYAMLSampleSpecFluentImpl that = (ConsoleYAMLSampleSpecFluentImpl) o;
        if (description != null ? !description.equals(that.description) :that.description != null) return false;
        if (snippet != null ? !snippet.equals(that.snippet) :that.snippet != null) return false;
        if (targetResource != null ? !targetResource.equals(that.targetResource) :that.targetResource != null) return false;
        if (title != null ? !title.equals(that.title) :that.title != null) return false;
        if (yaml != null ? !yaml.equals(that.yaml) :that.yaml != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(description,  snippet,  targetResource,  title,  yaml,  super.hashCode());
    }

}
