package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleYAMLSampleSpecBuilder extends ConsoleYAMLSampleSpecFluentImpl<ConsoleYAMLSampleSpecBuilder> implements VisitableBuilder<ConsoleYAMLSampleSpec,ConsoleYAMLSampleSpecBuilder> {

    ConsoleYAMLSampleSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleYAMLSampleSpecBuilder() { 
        this(true);
    }


    public ConsoleYAMLSampleSpecBuilder(Boolean validationEnabled) { 
        this(new ConsoleYAMLSampleSpec(), validationEnabled);
    }


    public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ConsoleYAMLSampleSpec(), validationEnabled);
    }


    public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent,ConsoleYAMLSampleSpec instance) { 
        this(fluent, instance, true);
    }


    public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent,ConsoleYAMLSampleSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDescription(instance.getDescription()); 
        fluent.withSnippet(instance.getSnippet()); 
        fluent.withTargetResource(instance.getTargetResource()); 
        fluent.withTitle(instance.getTitle()); 
        fluent.withYaml(instance.getYaml()); 
        this.validationEnabled = validationEnabled; 
    }


    public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpec instance) { 
        this(instance,true);
    }


    public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDescription(instance.getDescription()); 
        this.withSnippet(instance.getSnippet()); 
        this.withTargetResource(instance.getTargetResource()); 
        this.withTitle(instance.getTitle()); 
        this.withYaml(instance.getYaml()); 
        this.validationEnabled = validationEnabled; 
    }


    public ConsoleYAMLSampleSpec build() {
        ConsoleYAMLSampleSpec buildable = new ConsoleYAMLSampleSpec(fluent.getDescription(),fluent.isSnippet(),fluent.getTargetResource(),fluent.getTitle(),fluent.getYaml());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleYAMLSampleSpecBuilder that = (ConsoleYAMLSampleSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
