package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleExternalLogLinkFluentImpl<A extends ConsoleExternalLogLinkFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConsoleExternalLogLinkFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ConsoleExternalLogLinkSpecBuilder spec;

    public ConsoleExternalLogLinkFluentImpl() { 
    }


    public ConsoleExternalLogLinkFluentImpl(ConsoleExternalLogLink instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public ConsoleExternalLogLinkFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public ConsoleExternalLogLinkFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public ConsoleExternalLogLinkFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public ConsoleExternalLogLinkFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ConsoleExternalLogLinkFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ConsoleExternalLogLinkSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public ConsoleExternalLogLinkSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(ConsoleExternalLogLinkSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new ConsoleExternalLogLinkSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public A withNewSpec(String hrefTemplate,String namespaceFilter,String text) {
        return (A)withSpec(new ConsoleExternalLogLinkSpec(hrefTemplate, namespaceFilter, text));
    }

    public ConsoleExternalLogLinkFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public ConsoleExternalLogLinkFluent.SpecNested<A> withNewSpecLike(ConsoleExternalLogLinkSpec item) {
        return new SpecNestedImpl(item);
    }

    public ConsoleExternalLogLinkFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public ConsoleExternalLogLinkFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new ConsoleExternalLogLinkSpecBuilder().build());
    }

    public ConsoleExternalLogLinkFluent.SpecNested<A> editOrNewSpecLike(ConsoleExternalLogLinkSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConsoleExternalLogLinkFluentImpl that = (ConsoleExternalLogLinkFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ConsoleExternalLogLinkFluent.MetadataNested<N>> implements ConsoleExternalLogLinkFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) ConsoleExternalLogLinkFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class SpecNestedImpl<N> extends ConsoleExternalLogLinkSpecFluentImpl<ConsoleExternalLogLinkFluent.SpecNested<N>> implements ConsoleExternalLogLinkFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConsoleExternalLogLinkSpecBuilder builder;

        SpecNestedImpl(ConsoleExternalLogLinkSpec item) {
            this.builder = new ConsoleExternalLogLinkSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ConsoleExternalLogLinkSpecBuilder(this);
        }

        public N and() {
             return (N) ConsoleExternalLogLinkFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


}
