
package io.fabric8.openshift.api.model.console.v1;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "applicationMenu",
    "href",
    "location",
    "namespaceDashboard",
    "text"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class ConsoleLinkSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("applicationMenu")
    private ApplicationMenuSpec applicationMenu;
    /**
     * 
     * 
     */
    @JsonProperty("href")
    private String href;
    /**
     * 
     * 
     */
    @JsonProperty("location")
    private String location;
    /**
     * 
     * 
     */
    @JsonProperty("namespaceDashboard")
    private NamespaceDashboardSpec namespaceDashboard;
    /**
     * 
     * 
     */
    @JsonProperty("text")
    private String text;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ConsoleLinkSpec() {
    }

    /**
     * 
     * @param applicationMenu
     * @param location
     * @param href
     * @param text
     * @param namespaceDashboard
     */
    public ConsoleLinkSpec(ApplicationMenuSpec applicationMenu, String href, String location, NamespaceDashboardSpec namespaceDashboard, String text) {
        this.applicationMenu = applicationMenu;
        this.href = href;
        this.location = location;
        this.namespaceDashboard = namespaceDashboard;
        this.text = text;
    }

    /**
     * 
     * 
     * @return
     *     The applicationMenu
     */
    @JsonProperty("applicationMenu")
    public ApplicationMenuSpec getApplicationMenu() {
        return applicationMenu;
    }

    /**
     * 
     * 
     * @param applicationMenu
     *     The applicationMenu
     */
    @JsonProperty("applicationMenu")
    public void setApplicationMenu(ApplicationMenuSpec applicationMenu) {
        this.applicationMenu = applicationMenu;
    }

    /**
     * 
     * 
     * @return
     *     The href
     */
    @JsonProperty("href")
    public String getHref() {
        return href;
    }

    /**
     * 
     * 
     * @param href
     *     The href
     */
    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    /**
     * 
     * 
     * @return
     *     The location
     */
    @JsonProperty("location")
    public String getLocation() {
        return location;
    }

    /**
     * 
     * 
     * @param location
     *     The location
     */
    @JsonProperty("location")
    public void setLocation(String location) {
        this.location = location;
    }

    /**
     * 
     * 
     * @return
     *     The namespaceDashboard
     */
    @JsonProperty("namespaceDashboard")
    public NamespaceDashboardSpec getNamespaceDashboard() {
        return namespaceDashboard;
    }

    /**
     * 
     * 
     * @param namespaceDashboard
     *     The namespaceDashboard
     */
    @JsonProperty("namespaceDashboard")
    public void setNamespaceDashboard(NamespaceDashboardSpec namespaceDashboard) {
        this.namespaceDashboard = namespaceDashboard;
    }

    /**
     * 
     * 
     * @return
     *     The text
     */
    @JsonProperty("text")
    public String getText() {
        return text;
    }

    /**
     * 
     * 
     * @param text
     *     The text
     */
    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
