package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleCLIDownloadSpecBuilder extends ConsoleCLIDownloadSpecFluentImpl<ConsoleCLIDownloadSpecBuilder> implements VisitableBuilder<ConsoleCLIDownloadSpec,ConsoleCLIDownloadSpecBuilder> {

    ConsoleCLIDownloadSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleCLIDownloadSpecBuilder() { 
        this(true);
    }


    public ConsoleCLIDownloadSpecBuilder(Boolean validationEnabled) { 
        this(new ConsoleCLIDownloadSpec(), validationEnabled);
    }


    public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ConsoleCLIDownloadSpec(), validationEnabled);
    }


    public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpecFluent<?> fluent,ConsoleCLIDownloadSpec instance) { 
        this(fluent, instance, true);
    }


    public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpecFluent<?> fluent,ConsoleCLIDownloadSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDescription(instance.getDescription()); 
        fluent.withDisplayName(instance.getDisplayName()); 
        fluent.withLinks(instance.getLinks()); 
        this.validationEnabled = validationEnabled; 
    }


    public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpec instance) { 
        this(instance,true);
    }


    public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withLinks(instance.getLinks()); 
        this.validationEnabled = validationEnabled; 
    }


    public ConsoleCLIDownloadSpec build() {
        ConsoleCLIDownloadSpec buildable = new ConsoleCLIDownloadSpec(fluent.getDescription(),fluent.getDisplayName(),fluent.getLinks());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleCLIDownloadSpecBuilder that = (ConsoleCLIDownloadSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
