package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NamespaceDashboardSpecBuilder extends NamespaceDashboardSpecFluentImpl<NamespaceDashboardSpecBuilder> implements VisitableBuilder<NamespaceDashboardSpec,NamespaceDashboardSpecBuilder>{

    NamespaceDashboardSpecFluent<?> fluent;
    Boolean validationEnabled;

    public NamespaceDashboardSpecBuilder(){
            this(true);
    }
    public NamespaceDashboardSpecBuilder(Boolean validationEnabled){
            this(new NamespaceDashboardSpec(), validationEnabled);
    }
    public NamespaceDashboardSpecBuilder(NamespaceDashboardSpecFluent<?> fluent){
            this(fluent, true);
    }
    public NamespaceDashboardSpecBuilder(NamespaceDashboardSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NamespaceDashboardSpec(), validationEnabled);
    }
    public NamespaceDashboardSpecBuilder(NamespaceDashboardSpecFluent<?> fluent,NamespaceDashboardSpec instance){
            this(fluent, instance, true);
    }
    public NamespaceDashboardSpecBuilder(NamespaceDashboardSpecFluent<?> fluent,NamespaceDashboardSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
            fluent.withNamespaces(instance.getNamespaces()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamespaceDashboardSpecBuilder(NamespaceDashboardSpec instance){
            this(instance,true);
    }
    public NamespaceDashboardSpecBuilder(NamespaceDashboardSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNamespaceSelector(instance.getNamespaceSelector()); 
            this.withNamespaces(instance.getNamespaces()); 
            this.validationEnabled = validationEnabled; 
    }

    public NamespaceDashboardSpec build(){
            NamespaceDashboardSpec buildable = new NamespaceDashboardSpec(fluent.getNamespaceSelector(),fluent.getNamespaces());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamespaceDashboardSpecBuilder that = (NamespaceDashboardSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
