package io.fabric8.openshift.api.model.console.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleNotificationSpecFluentImpl<A extends ConsoleNotificationSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConsoleNotificationSpecFluent<A>{

    private String backgroundColor;
    private String color;
    private LinkBuilder link;
    private String location;
    private String text;

    public ConsoleNotificationSpecFluentImpl(){
    }
    public ConsoleNotificationSpecFluentImpl(ConsoleNotificationSpec instance){
            this.withBackgroundColor(instance.getBackgroundColor()); 
            this.withColor(instance.getColor()); 
            this.withLink(instance.getLink()); 
            this.withLocation(instance.getLocation()); 
            this.withText(instance.getText()); 
    }

    public String getBackgroundColor(){
            return this.backgroundColor;
    }

    public A withBackgroundColor(String backgroundColor){
            this.backgroundColor=backgroundColor; return (A) this;
    }

    public Boolean hasBackgroundColor(){
            return this.backgroundColor != null;
    }

    public A withNewBackgroundColor(String arg1){
            return (A)withBackgroundColor(new String(arg1));
    }

    public A withNewBackgroundColor(StringBuilder arg1){
            return (A)withBackgroundColor(new String(arg1));
    }

    public A withNewBackgroundColor(StringBuffer arg1){
            return (A)withBackgroundColor(new String(arg1));
    }

    public String getColor(){
            return this.color;
    }

    public A withColor(String color){
            this.color=color; return (A) this;
    }

    public Boolean hasColor(){
            return this.color != null;
    }

    public A withNewColor(String arg1){
            return (A)withColor(new String(arg1));
    }

    public A withNewColor(StringBuilder arg1){
            return (A)withColor(new String(arg1));
    }

    public A withNewColor(StringBuffer arg1){
            return (A)withColor(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildLink instead.
 * @return The buildable object.
 */
@Deprecated public Link getLink(){
            return this.link!=null?this.link.build():null;
    }

    public Link buildLink(){
            return this.link!=null?this.link.build():null;
    }

    public A withLink(Link link){
            _visitables.get("link").remove(this.link);
            if (link!=null){ this.link= new LinkBuilder(link); _visitables.get("link").add(this.link);} return (A) this;
    }

    public Boolean hasLink(){
            return this.link != null;
    }

    public A withNewLink(String href,String text){
            return (A)withLink(new Link(href, text));
    }

    public ConsoleNotificationSpecFluent.LinkNested<A> withNewLink(){
            return new LinkNestedImpl();
    }

    public ConsoleNotificationSpecFluent.LinkNested<A> withNewLinkLike(Link item){
            return new LinkNestedImpl(item);
    }

    public ConsoleNotificationSpecFluent.LinkNested<A> editLink(){
            return withNewLinkLike(getLink());
    }

    public ConsoleNotificationSpecFluent.LinkNested<A> editOrNewLink(){
            return withNewLinkLike(getLink() != null ? getLink(): new LinkBuilder().build());
    }

    public ConsoleNotificationSpecFluent.LinkNested<A> editOrNewLinkLike(Link item){
            return withNewLinkLike(getLink() != null ? getLink(): item);
    }

    public String getLocation(){
            return this.location;
    }

    public A withLocation(String location){
            this.location=location; return (A) this;
    }

    public Boolean hasLocation(){
            return this.location != null;
    }

    public A withNewLocation(String arg1){
            return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(StringBuilder arg1){
            return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(StringBuffer arg1){
            return (A)withLocation(new String(arg1));
    }

    public String getText(){
            return this.text;
    }

    public A withText(String text){
            this.text=text; return (A) this;
    }

    public Boolean hasText(){
            return this.text != null;
    }

    public A withNewText(String arg1){
            return (A)withText(new String(arg1));
    }

    public A withNewText(StringBuilder arg1){
            return (A)withText(new String(arg1));
    }

    public A withNewText(StringBuffer arg1){
            return (A)withText(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ConsoleNotificationSpecFluentImpl that = (ConsoleNotificationSpecFluentImpl) o;
            if (backgroundColor != null ? !backgroundColor.equals(that.backgroundColor) :that.backgroundColor != null) return false;
            if (color != null ? !color.equals(that.color) :that.color != null) return false;
            if (link != null ? !link.equals(that.link) :that.link != null) return false;
            if (location != null ? !location.equals(that.location) :that.location != null) return false;
            if (text != null ? !text.equals(that.text) :that.text != null) return false;
            return true;
    }


    public class LinkNestedImpl<N> extends LinkFluentImpl<ConsoleNotificationSpecFluent.LinkNested<N>> implements ConsoleNotificationSpecFluent.LinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LinkBuilder builder;
    
            LinkNestedImpl(Link item){
                    this.builder = new LinkBuilder(this, item);
            }
            LinkNestedImpl(){
                    this.builder = new LinkBuilder(this);
            }
    
    public N and(){
            return (N) ConsoleNotificationSpecFluentImpl.this.withLink(builder.build());
    }
    public N endLink(){
            return and();
    }

}


}
