package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ApplicationMenuSpecBuilder extends ApplicationMenuSpecFluentImpl<ApplicationMenuSpecBuilder> implements VisitableBuilder<ApplicationMenuSpec,ApplicationMenuSpecBuilder>{

    ApplicationMenuSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ApplicationMenuSpecBuilder(){
            this(true);
    }
    public ApplicationMenuSpecBuilder(Boolean validationEnabled){
            this(new ApplicationMenuSpec(), validationEnabled);
    }
    public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ApplicationMenuSpec(), validationEnabled);
    }
    public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent,ApplicationMenuSpec instance){
            this(fluent, instance, true);
    }
    public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent,ApplicationMenuSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withImageURL(instance.getImageURL()); 
            fluent.withSection(instance.getSection()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApplicationMenuSpecBuilder(ApplicationMenuSpec instance){
            this(instance,true);
    }
    public ApplicationMenuSpecBuilder(ApplicationMenuSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withImageURL(instance.getImageURL()); 
            this.withSection(instance.getSection()); 
            this.validationEnabled = validationEnabled; 
    }

    public ApplicationMenuSpec build(){
            ApplicationMenuSpec buildable = new ApplicationMenuSpec(fluent.getImageURL(),fluent.getSection());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ApplicationMenuSpecBuilder that = (ApplicationMenuSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
