package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleCLIDownloadListBuilder extends ConsoleCLIDownloadListFluentImpl<ConsoleCLIDownloadListBuilder> implements VisitableBuilder<ConsoleCLIDownloadList,ConsoleCLIDownloadListBuilder>{

    ConsoleCLIDownloadListFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleCLIDownloadListBuilder(){
            this(true);
    }
    public ConsoleCLIDownloadListBuilder(Boolean validationEnabled){
            this(new ConsoleCLIDownloadList(), validationEnabled);
    }
    public ConsoleCLIDownloadListBuilder(ConsoleCLIDownloadListFluent<?> fluent){
            this(fluent, true);
    }
    public ConsoleCLIDownloadListBuilder(ConsoleCLIDownloadListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConsoleCLIDownloadList(), validationEnabled);
    }
    public ConsoleCLIDownloadListBuilder(ConsoleCLIDownloadListFluent<?> fluent,ConsoleCLIDownloadList instance){
            this(fluent, instance, true);
    }
    public ConsoleCLIDownloadListBuilder(ConsoleCLIDownloadListFluent<?> fluent,ConsoleCLIDownloadList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConsoleCLIDownloadListBuilder(ConsoleCLIDownloadList instance){
            this(instance,true);
    }
    public ConsoleCLIDownloadListBuilder(ConsoleCLIDownloadList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConsoleCLIDownloadList build(){
            ConsoleCLIDownloadList buildable = new ConsoleCLIDownloadList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConsoleCLIDownloadListBuilder that = (ConsoleCLIDownloadListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
