package io.fabric8.openshift.api.model.console.v1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ApplicationMenuSpecFluentImpl<A extends ApplicationMenuSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ApplicationMenuSpecFluent<A>{

    private String imageURL;
    private String section;

    public ApplicationMenuSpecFluentImpl(){
    }
    public ApplicationMenuSpecFluentImpl(ApplicationMenuSpec instance){
            this.withImageURL(instance.getImageURL()); 
            this.withSection(instance.getSection()); 
    }

    public String getImageURL(){
            return this.imageURL;
    }

    public A withImageURL(String imageURL){
            this.imageURL=imageURL; return (A) this;
    }

    public Boolean hasImageURL(){
            return this.imageURL != null;
    }

    public A withNewImageURL(String arg1){
            return (A)withImageURL(new String(arg1));
    }

    public A withNewImageURL(StringBuilder arg1){
            return (A)withImageURL(new String(arg1));
    }

    public A withNewImageURL(StringBuffer arg1){
            return (A)withImageURL(new String(arg1));
    }

    public String getSection(){
            return this.section;
    }

    public A withSection(String section){
            this.section=section; return (A) this;
    }

    public Boolean hasSection(){
            return this.section != null;
    }

    public A withNewSection(String arg1){
            return (A)withSection(new String(arg1));
    }

    public A withNewSection(StringBuilder arg1){
            return (A)withSection(new String(arg1));
    }

    public A withNewSection(StringBuffer arg1){
            return (A)withSection(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ApplicationMenuSpecFluentImpl that = (ApplicationMenuSpecFluentImpl) o;
            if (imageURL != null ? !imageURL.equals(that.imageURL) :that.imageURL != null) return false;
            if (section != null ? !section.equals(that.section) :that.section != null) return false;
            return true;
    }




}
