package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleLinkSpecBuilder extends ConsoleLinkSpecFluentImpl<ConsoleLinkSpecBuilder> implements VisitableBuilder<ConsoleLinkSpec,ConsoleLinkSpecBuilder>{

    ConsoleLinkSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleLinkSpecBuilder(){
            this(true);
    }
    public ConsoleLinkSpecBuilder(Boolean validationEnabled){
            this(new ConsoleLinkSpec(), validationEnabled);
    }
    public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConsoleLinkSpec(), validationEnabled);
    }
    public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent,ConsoleLinkSpec instance){
            this(fluent, instance, true);
    }
    public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent,ConsoleLinkSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApplicationMenu(instance.getApplicationMenu()); 
            fluent.withHref(instance.getHref()); 
            fluent.withLocation(instance.getLocation()); 
            fluent.withNamespaceDashboard(instance.getNamespaceDashboard()); 
            fluent.withText(instance.getText()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConsoleLinkSpecBuilder(ConsoleLinkSpec instance){
            this(instance,true);
    }
    public ConsoleLinkSpecBuilder(ConsoleLinkSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApplicationMenu(instance.getApplicationMenu()); 
            this.withHref(instance.getHref()); 
            this.withLocation(instance.getLocation()); 
            this.withNamespaceDashboard(instance.getNamespaceDashboard()); 
            this.withText(instance.getText()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConsoleLinkSpec build(){
            ConsoleLinkSpec buildable = new ConsoleLinkSpec(fluent.getApplicationMenu(),fluent.getHref(),fluent.getLocation(),fluent.getNamespaceDashboard(),fluent.getText());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConsoleLinkSpecBuilder that = (ConsoleLinkSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
