package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleLinkBuilder extends ConsoleLinkFluentImpl<ConsoleLinkBuilder> implements VisitableBuilder<ConsoleLink,ConsoleLinkBuilder>{

    ConsoleLinkFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleLinkBuilder(){
            this(true);
    }
    public ConsoleLinkBuilder(Boolean validationEnabled){
            this(new ConsoleLink(), validationEnabled);
    }
    public ConsoleLinkBuilder(ConsoleLinkFluent<?> fluent){
            this(fluent, true);
    }
    public ConsoleLinkBuilder(ConsoleLinkFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConsoleLink(), validationEnabled);
    }
    public ConsoleLinkBuilder(ConsoleLinkFluent<?> fluent,ConsoleLink instance){
            this(fluent, instance, true);
    }
    public ConsoleLinkBuilder(ConsoleLinkFluent<?> fluent,ConsoleLink instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConsoleLinkBuilder(ConsoleLink instance){
            this(instance,true);
    }
    public ConsoleLinkBuilder(ConsoleLink instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConsoleLink build(){
            ConsoleLink buildable = new ConsoleLink(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConsoleLinkBuilder that = (ConsoleLinkBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
