package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleExternalLogLinkBuilder extends ConsoleExternalLogLinkFluentImpl<ConsoleExternalLogLinkBuilder> implements VisitableBuilder<ConsoleExternalLogLink,ConsoleExternalLogLinkBuilder>{

    ConsoleExternalLogLinkFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleExternalLogLinkBuilder(){
            this(true);
    }
    public ConsoleExternalLogLinkBuilder(Boolean validationEnabled){
            this(new ConsoleExternalLogLink(), validationEnabled);
    }
    public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLinkFluent<?> fluent){
            this(fluent, true);
    }
    public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLinkFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConsoleExternalLogLink(), validationEnabled);
    }
    public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLinkFluent<?> fluent,ConsoleExternalLogLink instance){
            this(fluent, instance, true);
    }
    public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLinkFluent<?> fluent,ConsoleExternalLogLink instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLink instance){
            this(instance,true);
    }
    public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLink instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConsoleExternalLogLink build(){
            ConsoleExternalLogLink buildable = new ConsoleExternalLogLink(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConsoleExternalLogLinkBuilder that = (ConsoleExternalLogLinkBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
