/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMapper;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class PipelineJobListener
extends ItemListener {
    private static final Logger logger = Logger.getLogger(PipelineJobListener.class.getName());
    private String server;
    private String defaultNamespace;

    public PipelineJobListener() {
        this.init();
    }

    @DataBoundConstructor
    public PipelineJobListener(String server, String defaultNamespace) {
        this.server = server;
        this.defaultNamespace = defaultNamespace;
        this.init();
    }

    private void init() {
        this.defaultNamespace = OpenShiftUtils.getNamespaceOrUseDefault(this.defaultNamespace, OpenShiftUtils.getOpenShiftClient());
    }

    public void onCreated(Item item) {
        super.onCreated(item);
        this.upsertItem(item);
    }

    public void onUpdated(Item item) {
        super.onUpdated(item);
        this.upsertItem(item);
    }

    public void onDeleted(Item item) {
        super.onDeleted(item);
        if (item instanceof WorkflowJob) {
            WorkflowJob job = (WorkflowJob)item;
            NamespaceName buildName = OpenShiftUtils.buildConfigNameFromJenkinsJobName(job.getName(), this.defaultNamespace);
            logger.info("Deleting BuildConfig " + buildName);
            String namespace = buildName.getNamespace();
            String buildConfigName = buildName.getName();
            try {
                ((ClientBuildConfigResource)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().buildConfigs().inNamespace(namespace)).withName(buildConfigName)).delete();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to delete BuildConfig in namespace: " + namespace + " for name: " + buildConfigName);
            }
        }
    }

    public void upsertItem(Item item) {
        if (item instanceof WorkflowJob) {
            WorkflowJob job = (WorkflowJob)item;
            logger.info("Updated WorkflowJob " + job.getDisplayName() + " replicating changes to OpenShift");
            this.upsertBuildConfigForJob(job);
        }
    }

    private void upsertBuildConfigForJob(WorkflowJob job) {
        BuildConfigProjectProperty buildConfigProjectProperty = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
        if (buildConfigProjectProperty == null || buildConfigProjectProperty.getBuildConfig() == null) {
            return;
        }
        BuildConfig jobBuildConfig = buildConfigProjectProperty.getBuildConfig();
        BuildConfigToJobMapper.updateBuildConfigFromJob(job, jobBuildConfig);
        BuildConfig serverBuildConfig = (BuildConfig)((ClientBuildConfigResource)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().buildConfigs().inNamespace(jobBuildConfig.getMetadata().getNamespace())).withName(jobBuildConfig.getMetadata().getName())).get();
        if (serverBuildConfig == null) {
            logger.log(Level.WARNING, "Failed to find BuildConfig in namespace: " + jobBuildConfig.getMetadata().getNamespace() + " for name: " + jobBuildConfig.getMetadata().getName());
            return;
        }
        if (jobBuildConfig.getMetadata().getResourceVersion().equals(serverBuildConfig.getMetadata().getResourceVersion()) && !OpenShiftUtils.isResourceWithoutStateEqual((HasMetadata)serverBuildConfig, (HasMetadata)jobBuildConfig)) {
            logger.log(Level.INFO, "Updating BuildConfig in namespace: " + jobBuildConfig.getMetadata().getNamespace() + " with name: " + jobBuildConfig.getMetadata().getName());
            try {
                ((ClientBuildConfigResource)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().buildConfigs().inNamespace(jobBuildConfig.getMetadata().getNamespace())).withName(jobBuildConfig.getMetadata().getName())).replace((Object)jobBuildConfig);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to update BuildConfig: " + NamespaceName.create((HasMetadata)jobBuildConfig) + ". " + e, e);
            }
        }
    }
}

