/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.DoneableBuild;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.EditableOpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class OpenShiftUtils {
    private static final Logger logger = Logger.getLogger(OpenShiftUtils.class.getName());
    private static OpenShiftClient openShiftClient;
    private static final DateTimeFormatter dateFormatter;

    public static synchronized void initializeOpenShiftClient(String serverUrl) {
        OpenShiftConfigBuilder configBuilder = new OpenShiftConfigBuilder();
        if (serverUrl != null && !serverUrl.isEmpty()) {
            configBuilder.withMasterUrl(serverUrl);
        }
        EditableOpenShiftConfig config = configBuilder.build();
        openShiftClient = new DefaultOpenShiftClient((Config)config);
    }

    public static synchronized OpenShiftClient getOpenShiftClient() {
        return openShiftClient;
    }

    public static synchronized void shutdownOpenShiftClient() {
        if (openShiftClient != null) {
            openShiftClient.close();
            openShiftClient = null;
        }
    }

    public static boolean isJenkinsBuildConfig(BuildConfig bc) {
        Map annotations;
        if ("JenkinsPipeline".equalsIgnoreCase(bc.getSpec().getStrategy().getType()) && bc.getSpec().getStrategy().getJenkinsPipelineStrategy() != null) {
            return true;
        }
        ObjectMeta metadata = bc.getMetadata();
        return metadata != null && (annotations = metadata.getAnnotations()) != null && annotations.get("fabric8.link.jenkins.job/label") != null;
    }

    public static String jenkinsJobName(BuildConfig bc, String defaultNamespace) {
        String namespace = bc.getMetadata().getNamespace();
        String name = bc.getMetadata().getName();
        return OpenShiftUtils.jenkinsJobName(namespace, name, defaultNamespace);
    }

    public static String jenkinsJobName(String namespace, String buildConfigName, String defaultNamespace) {
        if (namespace == null || namespace.length() == 0 || namespace.equals(defaultNamespace)) {
            return buildConfigName;
        }
        return namespace + "-" + buildConfigName;
    }

    public static String getNamespaceOrUseDefault(String configuredNamespace, OpenShiftClient client) {
        String namespace = configuredNamespace;
        if (StringUtils.isBlank((String)namespace) && StringUtils.isBlank((String)(namespace = client.getNamespace()))) {
            namespace = "default";
        }
        return namespace;
    }

    public static String getExternalServiceUrl(OpenShiftClient openShiftClient, String protocolText, String namespace, String serviceName) {
        String host;
        RouteSpec spec;
        try {
            Route route = (Route)((ClientResource)((ClientNonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(serviceName)).get();
            if (route != null && (spec = route.getSpec()) != null && (host = spec.getHost()) != null && host.length() > 0) {
                return protocolText + host;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not find Route for namespace " + namespace + " service " + serviceName + ". " + e, e);
        }
        try {
            Service service = (Service)((ClientResource)((ClientNonNamespaceOperation)openShiftClient.services().inNamespace(namespace)).withName(serviceName)).get();
            if (service != null && (spec = service.getSpec()) != null && (host = spec.getPortalIP()) != null && host.length() > 0) {
                return protocolText + host;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not find Route for namespace " + namespace + " service " + serviceName + ". " + e, e);
        }
        return protocolText + serviceName;
    }

    public static String getJenkinsURL(OpenShiftClient openShiftClient, String namespace) {
        return OpenShiftUtils.getExternalServiceUrl(openShiftClient, "http://", namespace, "jenkins");
    }

    public static void updateGitSourceUrl(BuildConfig buildConfig, String gitUrl, String ref) {
        BuildSource source;
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec == null) {
            spec = new BuildConfigSpec();
            buildConfig.setSpec(spec);
        }
        if ((source = spec.getSource()) == null) {
            source = new BuildSource();
            spec.setSource(source);
        }
        source.setType("Git");
        GitBuildSource gitSource = source.getGit();
        if (gitSource == null) {
            gitSource = new GitBuildSource();
            source.setGit(gitSource);
        }
        gitSource.setUri(gitUrl);
        gitSource.setRef(ref);
    }

    public static void cancelOpenShiftBuild(Build build) {
        logger.info("cancelling build in namespace " + build.getMetadata().getNamespace() + " with name: " + build.getMetadata().getName());
        ((DoneableBuild)((BuildFluent.StatusNested)((DoneableBuild)((ClientResource)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().builds().inNamespace(build.getMetadata().getNamespace())).withName(build.getMetadata().getName())).edit()).editStatus().withPhase("Cancelled")).endStatus()).done();
    }

    public static NamespaceName buildConfigNameFromJenkinsJobName(String jobName, String defaultNamespace) {
        return new NamespaceName(defaultNamespace, jobName);
    }

    public static long parseResourceVersion(HasMetadata obj) {
        try {
            return Long.parseLong(obj.getMetadata().getResourceVersion());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static String formatTimestamp(long timestamp) {
        return dateFormatter.print((ReadableInstant)new DateTime(timestamp));
    }

    public static long parseTimestamp(String timestamp) {
        return dateFormatter.parseMillis(timestamp);
    }

    public static boolean isResourceWithoutStateEqual(HasMetadata oldObj, HasMetadata newObj) {
        try {
            byte[] oldDigest = MessageDigest.getInstance("MD5").digest(OpenShiftUtils.dumpWithoutRuntimeStateAsYaml(oldObj).getBytes(StandardCharsets.UTF_8));
            byte[] newDigest = MessageDigest.getInstance("MD5").digest(OpenShiftUtils.dumpWithoutRuntimeStateAsYaml(newObj).getBytes(StandardCharsets.UTF_8));
            return Arrays.equals(oldDigest, newDigest);
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String dumpWithoutRuntimeStateAsYaml(HasMetadata obj) throws JsonProcessingException {
        ObjectMapper statelessMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        statelessMapper.addMixInAnnotations(ObjectMeta.class, ObjectMetaMixIn.class);
        statelessMapper.addMixInAnnotations(ReplicationController.class, StatelessReplicationControllerMixIn.class);
        return statelessMapper.writeValueAsString((Object)obj);
    }

    static {
        dateFormatter = ISODateTimeFormat.dateTimeNoMillis();
    }

    abstract class ObjectMetaMixIn
    extends ObjectMeta {
        @JsonIgnore
        private String creationTimestamp;
        @JsonIgnore
        private String deletionTimestamp;
        @JsonIgnore
        private Long generation;
        @JsonIgnore
        private String resourceVersion;
        @JsonIgnore
        private String selfLink;
        @JsonIgnore
        private String uid;

        ObjectMetaMixIn() {
        }

        @JsonIgnore
        public abstract String getCreationTimestamp();

        @JsonIgnore
        public abstract String getDeletionTimestamp();

        @JsonIgnore
        public abstract Long getGeneration();

        @JsonIgnore
        public abstract String getResourceVersion();

        @JsonIgnore
        public abstract String getSelfLink();

        @JsonIgnore
        public abstract String getUid();
    }

    abstract class StatelessReplicationControllerMixIn
    extends ReplicationController {
        @JsonIgnore
        private ReplicationControllerStatus status;

        StatelessReplicationControllerMixIn() {
        }

        @JsonIgnore
        public abstract ReplicationControllerStatus getStatus();
    }
}

