/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;

public class NamespaceName {
    private final String namespace;
    private final String name;

    public NamespaceName(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public static NamespaceName create(HasMetadata hasMetadata) {
        NamespaceName.notNull(hasMetadata, "resource");
        ObjectMeta metadata = hasMetadata.getMetadata();
        NamespaceName.notNull(metadata, "metadata");
        String name = metadata.getName();
        String namespace = metadata.getNamespace();
        NamespaceName.notNull(name, "metadata.name");
        NamespaceName.notNull(namespace, "metadata.namespace");
        return new NamespaceName(namespace, name);
    }

    public String toString() {
        return "NamespaceName{" + this.namespace + ":" + this.name + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceName that = (NamespaceName)o;
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static void notNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(name + " must be specified");
        }
    }
}

