/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.model.Cause;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.util.XStream2;
import io.fabric8.jenkins.openshiftsync.BuildCause;
import io.fabric8.jenkins.openshiftsync.BuildName;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class JenkinsUtils {
    private static final Logger logger = Logger.getLogger(JenkinsUtils.class.getName());

    public static Job getJob(String job) {
        TopLevelItem item;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && (item = jenkins.getItem(job)) instanceof Job) {
            return (Job)item;
        }
        return null;
    }

    public static Run getRun(String jobName, String buildName) {
        Job job = JenkinsUtils.getJob(jobName);
        if (job != null) {
            return job.getBuild(buildName);
        }
        return null;
    }

    public static Run getRun(BuildName buildName) {
        return JenkinsUtils.getRun(buildName.getJobName(), buildName.getBuildName());
    }

    public static String getRootUrl() {
        String root = null;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            root = jenkins.getRootUrl();
        }
        if (root == null || root.length() == 0) {
            root = "http://localhost:8080/jenkins/";
        }
        return root;
    }

    public static void triggerJob(Job job, Build build) {
        BuildCause cause = new BuildCause(build);
        if (job instanceof WorkflowJob) {
            WorkflowJob workflowJob = (WorkflowJob)job;
            workflowJob.scheduleBuild((Cause)cause);
        }
    }

    public static void cancelBuild(Job job, Build build) {
        String buildUid = build.getMetadata().getUid();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            Queue buildQueue = jenkins.getQueue();
            for (Queue.Item item : buildQueue.getItems()) {
                for (Cause cause : item.getCauses()) {
                    if (!(cause instanceof BuildCause) || !((BuildCause)cause).getBuild().getMetadata().getUid().equals(buildUid)) continue;
                    buildQueue.cancel(item);
                    OpenShiftUtils.cancelOpenShiftBuild(build);
                    return;
                }
            }
            for (Object obj : job.getNewBuilds()) {
                Executor e;
                WorkflowRun b;
                BuildCause cause;
                if (!(obj instanceof WorkflowRun) || (cause = (BuildCause)(b = (WorkflowRun)obj).getCause(BuildCause.class)) == null || !cause.getBuild().getMetadata().getUid().equals(buildUid) || (e = b.getExecutor()) == null) continue;
                e.interrupt(Result.ABORTED);
                OpenShiftUtils.cancelOpenShiftBuild(build);
                return;
            }
        }
    }

    public static XStream2 xstream2() {
        XStream2 xs = new XStream2();
        xs.aliasType("OpenShiftBuildConfig", BuildConfig.class);
        xs.addCompatibilityAlias(BuildConfig.class.getName(), BuildConfig.class);
        xs.addCompatibilityAlias("OpenShiftBuildConfig", BuildConfig.class);
        return xs;
    }
}

