/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.jenkins.openshiftsync.BuildConfigWatcher;
import io.fabric8.jenkins.openshiftsync.BuildWatcher;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class GlobalPluginConfiguration
extends GlobalConfiguration {
    private static final Logger logger = Logger.getLogger(GlobalPluginConfiguration.class.getName());
    private boolean enabled = true;
    private String server;
    private String namespace;
    private transient BuildWatcher buildWatcher;
    private transient BuildConfigWatcher buildConfigWatcher;

    @DataBoundConstructor
    public GlobalPluginConfiguration(boolean enable, String server, String namespace) {
        this.enabled = enable;
        this.server = server;
        this.namespace = namespace;
        this.configChange();
    }

    public GlobalPluginConfiguration() {
        this.load();
        this.configChange();
    }

    public static GlobalPluginConfiguration get() {
        return (GlobalPluginConfiguration)((Object)GlobalConfiguration.all().get(GlobalPluginConfiguration.class));
    }

    public String getDisplayName() {
        return "OpenShift Jenkins Sync";
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        this.configChange();
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    private void configChange() {
        if (this.namespace == null) {
            this.namespace = System.getenv("KUBERNETES_NAMESPACE");
        }
        logger.info("using default kubernetes namespace: " + this.namespace);
        if (!this.enabled) {
            if (this.buildConfigWatcher != null) {
                this.buildConfigWatcher.stop();
            }
            if (this.buildWatcher != null) {
                this.buildWatcher.stop();
            }
            OpenShiftUtils.shutdownOpenShiftClient();
            return;
        }
        if (this.enabled) {
            OpenShiftUtils.initializeOpenShiftClient(this.server);
            this.namespace = OpenShiftUtils.getNamespaceOrUseDefault(this.namespace, OpenShiftUtils.getOpenShiftClient());
            this.buildWatcher = new BuildWatcher(this.namespace);
            this.buildWatcher.start();
            this.buildConfigWatcher = new BuildConfigWatcher(this.namespace);
            this.buildConfigWatcher.start();
        }
    }
}

