/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Job;
import io.fabric8.jenkins.openshiftsync.BuildTrigger;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.apache.commons.lang.StringUtils;

public class BuildWatcher
implements Watcher<Build> {
    private static final Logger logger = Logger.getLogger(BuildWatcher.class.getName());
    private final String namespace;
    private Watch newBuildsWatch;
    private Watch runningBuildsWatch;

    public BuildWatcher(String defaultNamespace) {
        this.namespace = defaultNamespace;
    }

    public void start() {
        BuildList builds;
        if (this.namespace != null && !this.namespace.isEmpty()) {
            builds = (BuildList)((FilterWatchListDeletable)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().builds().inNamespace(this.namespace)).withField("status", "New")).list();
            this.newBuildsWatch = (Watch)((Watchable)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().builds().inNamespace(this.namespace)).withResourceVersion(builds.getMetadata().getResourceVersion())).watch((Object)this);
            this.runningBuildsWatch = (Watch)((Watchable)((FilterWatchListDeletable)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().builds().inNamespace(this.namespace)).withField("status", "Running")).withResourceVersion(builds.getMetadata().getResourceVersion())).watch((Object)this);
        } else {
            builds = (BuildList)((FilterWatchListDeletable)((FilterWatchListMultiDeletable)OpenShiftUtils.getOpenShiftClient().builds().inAnyNamespace()).withField("status", "New")).list();
            this.newBuildsWatch = (Watch)((Watchable)((FilterWatchListMultiDeletable)OpenShiftUtils.getOpenShiftClient().builds().inAnyNamespace()).withResourceVersion(builds.getMetadata().getResourceVersion())).watch((Object)this);
            this.runningBuildsWatch = (Watch)((Watchable)((FilterWatchListDeletable)((FilterWatchListMultiDeletable)OpenShiftUtils.getOpenShiftClient().builds().inAnyNamespace()).withField("status", "Running")).withResourceVersion(builds.getMetadata().getResourceVersion())).watch((Object)this);
        }
        logger.info("Now handling startup builds!!");
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Jenkins jenkins;
                logger.info("Waiting for Jenkins to be started");
                while ((jenkins = Jenkins.getInstance()) == null || !jenkins.isAcceptingTasks()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                logger.info("loading initial Builds resources");
                try {
                    BuildWatcher.this.onInitialBuilds(builds);
                    logger.info("loaded initial Builds resources");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to load initial Builds: " + e, e);
                }
            }
        };
        Timer.get().schedule(task, 500L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.newBuildsWatch != null) {
            this.newBuildsWatch.close();
        }
        if (this.runningBuildsWatch != null) {
            this.runningBuildsWatch.close();
        }
    }

    public void onClose(KubernetesClientException e) {
        if (e != null) {
            logger.warning(e.toString());
            if (e.getStatus() != null && e.getStatus().getCode() == 410) {
                this.stop();
                this.start();
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void onInitialBuilds(BuildList buildList) {
        List items = buildList.getItems();
        if (items != null) {
            Collections.sort(items, new Comparator<Build>(){

                @Override
                public int compare(Build b1, Build b2) {
                    return Long.compare(OpenShiftUtils.parseTimestamp(b1.getMetadata().getCreationTimestamp()), OpenShiftUtils.parseTimestamp(b2.getMetadata().getCreationTimestamp()));
                }
            });
            for (Build build : items) {
                if (!build.getStatus().getPhase().equals("New")) continue;
                try {
                    this.buildAdded(build);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public void eventReceived(Watcher.Action action, Build build) {
        try {
            switch (action) {
                case ADDED: {
                    this.buildAdded(build);
                    break;
                }
                case MODIFIED: {
                    this.buildModified(build);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    public void errorReceived(Status status) {
        if (status != null) {
            logger.warning("Watch error received: " + status.toString());
        }
    }

    private void buildModified(Build build) {
        Job job;
        if (Boolean.TRUE.equals(build.getStatus().getCancelled()) && (job = this.getJobFromBuild(build)) != null) {
            JenkinsUtils.cancelBuild(job, build);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void buildAdded(Build build) throws IOException {
        if (build.getStatus() != null && Boolean.TRUE.equals(build.getStatus().getCancelled())) {
            OpenShiftUtils.cancelOpenShiftBuild(build);
            return;
        }
        Job job = this.getJobFromBuild(build);
        if (job != null) {
            JenkinsUtils.triggerJob(job, build);
        }
    }

    private Job getJobFromBuild(Build build) {
        String buildConfigName = build.getStatus().getConfig().getName();
        if (StringUtils.isEmpty((String)buildConfigName)) {
            return null;
        }
        BuildConfig buildConfig = (BuildConfig)((ClientBuildConfigResource)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().buildConfigs().inNamespace(build.getMetadata().getNamespace())).withName(buildConfigName)).get();
        if (buildConfig == null) {
            return null;
        }
        return BuildTrigger.DESCRIPTOR.getJobFromBuildConfigUid(buildConfig.getMetadata().getUid());
    }
}

