/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildTrigger
extends Trigger<Job<?, ?>> {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger logger = Logger.getLogger(BuildTrigger.class.getName());
    private transient BuildConfigProjectProperty buildConfigProjectProperty;

    @DataBoundConstructor
    public BuildTrigger() {
    }

    public void start(Job<?, ?> job, boolean newInstance) {
        super.start(job, newInstance);
        this.buildConfigProjectProperty = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
        if (this.buildConfigProjectProperty == null) {
            return;
        }
        BuildTrigger.DESCRIPTOR.addBuildConfigTrigger(this.buildConfigProjectProperty.getBuildConfig().getMetadata().getUid(), (Job)this.job);
    }

    public void stop() {
        String name = this.job != null ? ((Job)this.job).getFullName() : "NOT STARTED";
        logger.log(Level.INFO, "Stopping the OpenShift Build trigger for project {0}", name);
        if (this.job != null) {
            String buildConfigUid;
            this.buildConfigProjectProperty = (BuildConfigProjectProperty)((Job)this.job).getProperty(BuildConfigProjectProperty.class);
            if (this.buildConfigProjectProperty != null && !StringUtils.isEmpty((String)(buildConfigUid = this.buildConfigProjectProperty.getBuildConfig().getMetadata().getUid()))) {
                BuildTrigger.DESCRIPTOR.removeBuildConfigTrigger(buildConfigUid, (Job)this.job);
            }
        }
        super.stop();
    }

    public void run() {
        logger.log(Level.FINE, "Using Build watch as trigger, so not running trigger");
    }

    public static DescriptorImpl getDscp() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends TriggerDescriptor {
        private transient Map<String, Job> buildConfigJobs;

        public DescriptorImpl() {
            this.load();
            if (this.buildConfigJobs == null) {
                this.buildConfigJobs = new ConcurrentHashMap<String, Job>();
            }
            this.save();
        }

        public boolean isApplicable(Item item) {
            return item instanceof Job;
        }

        public String getDisplayName() {
            return "OpenShift Jenkins Pipeline Builder";
        }

        private void addBuildConfigTrigger(String buildConfigUid, Job job) {
            if (job == null || StringUtils.isEmpty((String)buildConfigUid)) {
                return;
            }
            logger.log(Level.FINE, "Adding [{0}] to build config [{1}]", new String[]{job.getFullName(), buildConfigUid});
            this.buildConfigJobs.put(buildConfigUid, job);
        }

        private void removeBuildConfigTrigger(String buildConfigUid, Job job) {
            logger.log(Level.FINE, "Removing [{0}] from build config [{1}]", new Object[]{job.getFullName(), buildConfigUid});
            this.buildConfigJobs.remove(buildConfigUid);
        }

        public Job getJobFromBuildConfigUid(String buildConfigUid) {
            logger.log(Level.FINE, "Retrieving triggers for build config [{0}]", new String[]{buildConfigUid});
            Job job = this.buildConfigJobs.get(buildConfigUid);
            if (job != null) {
                logger.log(Level.FINE, "Found project [{0}] for build config uid [{1}]", new Object[]{job.getFullName(), buildConfigUid});
            }
            return job;
        }
    }
}

