/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.workflow.rest.external.RunExt;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.fabric8.jenkins.openshiftsync.BuildCause;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.DoneableBuild;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class BuildSyncRunListener
extends RunListener<Run> {
    private static final Logger logger = Logger.getLogger(BuildSyncRunListener.class.getName());
    private long pollPeriodMs = 2000L;
    private String defaultNamespace;
    private transient Set<Run> runsToPoll = new CopyOnWriteArraySet<Run>();
    private transient AtomicBoolean timerStarted = new AtomicBoolean(false);

    public BuildSyncRunListener() {
        this.init();
    }

    @DataBoundConstructor
    public BuildSyncRunListener(long pollPeriodMs) {
        this.pollPeriodMs = pollPeriodMs;
        this.init();
    }

    public static String joinPaths(String ... strings) {
        StringBuilder buffer = new StringBuilder();
        for (String string : strings) {
            if (string == null) continue;
            if (buffer.length() > 0) {
                boolean bufferEndsWithSeparator = buffer.toString().endsWith("/");
                boolean stringStartsWithSeparator = string.startsWith("/");
                if (bufferEndsWithSeparator) {
                    if (stringStartsWithSeparator) {
                        string = string.substring(1);
                    }
                } else if (!stringStartsWithSeparator) {
                    buffer.append("/");
                }
            }
            buffer.append(string);
        }
        return buffer.toString();
    }

    private void init() {
        this.defaultNamespace = OpenShiftUtils.getNamespaceOrUseDefault(this.defaultNamespace, OpenShiftUtils.getOpenShiftClient());
    }

    public void onStarted(Run run, TaskListener listener) {
        if (this.shouldPollRun(run)) {
            try {
                BuildCause cause = (BuildCause)run.getCause(BuildCause.class);
                if (cause != null && cause.getBuild() != null) {
                    run.setDescription(cause.getBuild().getMetadata().getNamespace() + "/" + cause.getBuild().getMetadata().getName());
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Cannot set build description: " + e);
            }
            this.checkTimerStarted();
            if (this.runsToPoll.add(run)) {
                logger.info("starting polling build " + run.getUrl());
            }
        } else {
            logger.fine("not polling polling build " + run.getUrl() + " as its not a WorkflowJob");
        }
        super.onStarted(run, listener);
    }

    protected void checkTimerStarted() {
        if (this.timerStarted.compareAndSet(false, true)) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    BuildSyncRunListener.this.pollLoop();
                }
            };
            Timer.get().scheduleAtFixedRate(task, this.pollPeriodMs, this.pollPeriodMs, TimeUnit.MILLISECONDS);
        }
    }

    public void onCompleted(Run run, @Nonnull TaskListener listener) {
        this.runsToPoll.remove(run);
        this.pollRun(run);
        logger.info("onCompleted " + run.getUrl());
        super.onCompleted(run, listener);
    }

    public void onDeleted(Run run) {
        this.runsToPoll.remove(run);
        this.pollRun(run);
        logger.info("onDeleted " + run.getUrl());
        super.onDeleted(run);
    }

    public void onFinalized(Run run) {
        this.pollRun(run);
        logger.info("onFinalized " + run.getUrl());
        super.onFinalized(run);
    }

    protected void pollLoop() {
        for (Run run : this.runsToPoll) {
            this.pollRun(run);
        }
    }

    protected void pollRun(Run run) {
        if (!(run instanceof WorkflowRun)) {
            throw new IllegalStateException("Cannot poll a non-workflow run");
        }
        RunExt wfRunExt = RunExt.create((WorkflowRun)((WorkflowRun)run));
        try {
            String json = new ObjectMapper().writeValueAsString((Object)wfRunExt);
            this.upsertBuild(run, json);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.WARNING, "Failed to serialize workflow run. " + (Object)((Object)e), e);
        }
    }

    private void upsertBuild(Run run, String json) {
        if (run == null) {
            return;
        }
        BuildCause cause = (BuildCause)run.getCause(BuildCause.class);
        if (cause == null || cause.getBuild() == null) {
            return;
        }
        Build build = cause.getBuild();
        String rootUrl = OpenShiftUtils.getJenkinsURL(OpenShiftUtils.getOpenShiftClient(), this.defaultNamespace);
        String logsUrl = BuildSyncRunListener.joinPaths(rootUrl, run.getUrl(), "/consoleText");
        String name = build.getMetadata().getName();
        String phase = this.runToBuildPhase(run);
        long started = this.getStartTime(run);
        String startTime = null;
        String completionTime = null;
        if (started > 0L) {
            startTime = OpenShiftUtils.formatTimestamp(started);
            long duration = this.getDuration(run);
            if (duration > 0L) {
                completionTime = OpenShiftUtils.formatTimestamp(started + duration);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("generated build in namespace " + this.defaultNamespace + " with name: " + name + " phase: " + build.getStatus().getPhase() + " data: " + build);
        }
        logger.info("replacing build in namespace " + this.defaultNamespace + " with name: " + name + " phase: " + build.getStatus().getPhase());
        ((DoneableBuild)((BuildFluent.StatusNested)((BuildFluent.StatusNested)((BuildFluent.StatusNested)((DoneableBuild)((BuildFluent.MetadataNested)((BuildFluent.MetadataNested)((BuildFluent.MetadataNested)((DoneableBuild)((ClientResource)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().builds().inNamespace(this.defaultNamespace)).withName(name)).edit()).editMetadata().addToAnnotations("openshift.io/jenkins-status-json", json)).addToAnnotations("openshift.io/jenkins-build-uri", run.getUrl())).addToAnnotations("openshift.io/jenkins-log-url", logsUrl)).endMetadata()).editStatus().withPhase(phase)).withStartTimestamp(startTime)).withCompletionTimestamp(completionTime)).endStatus()).done();
    }

    private long getStartTime(Run run) {
        return run.getStartTimeInMillis();
    }

    private long getDuration(Run run) {
        return run.getDuration();
    }

    private String runToBuildPhase(Run run) {
        if (run != null && !run.hasntStartedYet()) {
            if (run.isBuilding()) {
                return "Running";
            }
            Result result = run.getResult();
            if (result != null) {
                if (result.equals(Result.SUCCESS)) {
                    return "Complete";
                }
                if (result.equals(Result.ABORTED)) {
                    return "Cancelled";
                }
                if (result.equals(Result.FAILURE)) {
                    return "Failed";
                }
                if (result.equals(Result.UNSTABLE)) {
                    return "Failed";
                }
                return "Pending";
            }
        }
        return "New";
    }

    protected boolean shouldPollRun(Run run) {
        return run instanceof WorkflowRun && run.getCause(BuildCause.class) != null;
    }
}

