/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Queue;
import io.fabric8.jenkins.openshiftsync.BuildCause;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import java.util.List;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class BuildDecisionHandler
extends Queue.QueueDecisionHandler {
    public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
        BuildConfig buildConfig;
        WorkflowJob wj;
        BuildConfigProjectProperty buildConfigProjectProperty;
        if (p instanceof WorkflowJob && !this.isOpenShiftBuildCause(actions) && (buildConfigProjectProperty = (BuildConfigProjectProperty)(wj = (WorkflowJob)p).getProperty(BuildConfigProjectProperty.class)) != null && (buildConfig = buildConfigProjectProperty.getBuildConfig()) != null) {
            ((ClientBuildConfigResource)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().buildConfigs().inNamespace(buildConfig.getMetadata().getNamespace())).withName(buildConfig.getMetadata().getName())).instantiate((Object)((BuildRequestBuilder)((BuildRequestFluent.MetadataNested)new BuildRequestBuilder().withNewMetadata().withName(buildConfig.getMetadata().getName())).endMetadata()).build());
            return false;
        }
        return true;
    }

    private boolean isOpenShiftBuildCause(List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            for (Cause cause : causeAction.getCauses()) {
                if (!(cause instanceof BuildCause)) continue;
                return true;
            }
        }
        return false;
    }
}

