/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.remoting.Callable;
import hudson.security.ACL;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMapper;
import io.fabric8.jenkins.openshiftsync.BuildTrigger;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.apache.tools.ant.filters.StringInputStream;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jvnet.hudson.reactor.ReactorException;

public class BuildConfigWatcher
implements Watcher<BuildConfig> {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String namespace;
    private Watch buildConfigWatch;

    public BuildConfigWatcher(String defaultNamespace) {
        this.namespace = defaultNamespace;
    }

    public void start() {
        BuildConfigList buildConfigs;
        if (this.namespace != null && !this.namespace.isEmpty()) {
            buildConfigs = (BuildConfigList)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().buildConfigs().inNamespace(this.namespace)).list();
            this.buildConfigWatch = (Watch)((Watchable)((ClientNonNamespaceOperation)OpenShiftUtils.getOpenShiftClient().buildConfigs().inNamespace(this.namespace)).withResourceVersion(buildConfigs.getMetadata().getResourceVersion())).watch((Object)this);
        } else {
            buildConfigs = (BuildConfigList)((FilterWatchListMultiDeletable)OpenShiftUtils.getOpenShiftClient().buildConfigs().inAnyNamespace()).list();
            this.buildConfigWatch = (Watch)((Watchable)((FilterWatchListMultiDeletable)OpenShiftUtils.getOpenShiftClient().buildConfigs().inAnyNamespace()).withResourceVersion(buildConfigs.getMetadata().getResourceVersion())).watch((Object)this);
        }
        this.logger.info("Now handling startup build configs!!");
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Jenkins jenkins;
                BuildConfigWatcher.this.logger.info("Waiting for Jenkins to be started");
                while ((jenkins = Jenkins.getInstance()) == null || !jenkins.isAcceptingTasks()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BuildConfigWatcher.this.logger.info("loading initial BuildConfigs resources");
                try {
                    BuildConfigWatcher.this.onInitialBuildConfigs(buildConfigs);
                    BuildConfigWatcher.this.logger.info("loaded initial BuildConfigs resources");
                }
                catch (Exception e) {
                    BuildConfigWatcher.this.logger.log(Level.SEVERE, "Failed to load initial BuildConfigs: " + e, e);
                }
            }
        };
        Timer.get().schedule(task, 500L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.buildConfigWatch != null) {
            this.buildConfigWatch.close();
        }
    }

    public void onClose(KubernetesClientException e) {
        if (e != null) {
            this.logger.warning(e.toString());
            if (e.getStatus() != null && e.getStatus().getCode() == 410) {
                this.stop();
                this.start();
            }
        }
    }

    public void errorReceived(Status status) {
        if (status != null) {
            this.logger.warning("Watch error received: " + status.toString());
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void onInitialBuildConfigs(BuildConfigList buildConfigs) {
        List items = buildConfigs.getItems();
        if (items != null) {
            for (BuildConfig buildConfig : items) {
                try {
                    this.upsertJob(buildConfig);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public void eventReceived(Watcher.Action action, BuildConfig buildConfig) {
        try {
            switch (action) {
                case ADDED: {
                    this.upsertJob(buildConfig);
                    break;
                }
                case DELETED: {
                    this.deleteJob(buildConfig);
                    break;
                }
                case MODIFIED: {
                    this.modifyJob(buildConfig);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void upsertJob(final BuildConfig buildConfig) throws IOException {
        if (OpenShiftUtils.isJenkinsBuildConfig(buildConfig)) {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, IOException>(){

                public Void call() throws IOException {
                    String jobName = OpenShiftUtils.jenkinsJobName(buildConfig, BuildConfigWatcher.this.namespace);
                    Job<WorkflowJob, WorkflowRun> jobFromBuildConfig = BuildConfigToJobMapper.mapBuildConfigToJob(buildConfig, BuildConfigWatcher.this.namespace);
                    if (jobFromBuildConfig == null) {
                        return null;
                    }
                    jobFromBuildConfig.addProperty((JobProperty)new BuildConfigProjectProperty(buildConfig));
                    StringInputStream jobStream = new StringInputStream(JenkinsUtils.xstream2().toXML(jobFromBuildConfig));
                    Jenkins jenkins = Jenkins.getInstance();
                    Job job = BuildTrigger.getDscp().getJobFromBuildConfigUid(buildConfig.getMetadata().getUid());
                    if (job == null) {
                        jenkins.createProjectFromXML(jobName, (InputStream)jobStream);
                        BuildConfigWatcher.this.logger.info("Created job " + jobName + " from BuildConfig " + NamespaceName.create((HasMetadata)buildConfig) + " with revision: " + buildConfig.getMetadata().getResourceVersion());
                    } else {
                        BuildConfigProjectProperty buildConfigProjectProperty = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
                        if (buildConfigProjectProperty != null) {
                            long updatedBCResourceVersion = OpenShiftUtils.parseResourceVersion((HasMetadata)buildConfig);
                            long oldBCResourceVersion = OpenShiftUtils.parseResourceVersion((HasMetadata)buildConfigProjectProperty.getBuildConfig());
                            if (oldBCResourceVersion > updatedBCResourceVersion) {
                                return null;
                            }
                        }
                        StreamSource source = new StreamSource((InputStream)jobStream);
                        job.updateByXml((Source)source);
                        job.save();
                        BuildConfigWatcher.this.logger.info("Updated job " + jobName + " from BuildConfig " + NamespaceName.create((HasMetadata)buildConfig) + " with revision: " + buildConfig.getMetadata().getResourceVersion());
                    }
                    return null;
                }
            });
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void modifyJob(BuildConfig buildConfig) throws Exception {
        if (OpenShiftUtils.isJenkinsBuildConfig(buildConfig)) {
            this.upsertJob(buildConfig);
            return;
        }
        this.deleteJob(buildConfig);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void deleteJob(final BuildConfig buildConfig) throws Exception {
        final Job job = BuildTrigger.getDscp().getJobFromBuildConfigUid(buildConfig.getMetadata().getUid());
        if (job != null) {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                public Void call() throws Exception {
                    job.delete();
                    try {
                        Jenkins jenkins = Jenkins.getInstance();
                        if (jenkins != null) {
                            jenkins.reload();
                        }
                    }
                    catch (ReactorException e) {
                        BuildConfigWatcher.this.logger.log(Level.SEVERE, "Failed to reload jenkins job after deleting " + job.getName() + " from BuildConfig " + NamespaceName.create((HasMetadata)buildConfig));
                    }
                    return null;
                }
            });
        }
    }
}

