/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.triggers.Trigger;
import io.fabric8.jenkins.openshiftsync.BuildTrigger;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategy;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class BuildConfigToJobMapper {
    public static final String JENKINS_PIPELINE_BUILD_STRATEGY = "JenkinsPipeline";
    public static final String DEFAULT_JENKINS_FILEPATH = "Jenkinsfile";
    private static final Logger LOGGER = Logger.getLogger(BuildConfigToJobMapper.class.getName());

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Job<WorkflowJob, WorkflowRun> mapBuildConfigToJob(BuildConfig bc, String defaultNamespace) {
        WorkflowJob job;
        block9: {
            if (!OpenShiftUtils.isJenkinsBuildConfig(bc)) {
                return null;
            }
            job = new WorkflowJob((ItemGroup)Jenkins.getInstance(), OpenShiftUtils.jenkinsJobName(bc, defaultNamespace));
            BuildConfigSpec spec = bc.getSpec();
            BuildSource source = null;
            String jenkinsfile = null;
            String jenkinsfilePath = null;
            if (spec != null) {
                JenkinsPipelineBuildStrategy jenkinsPipelineStrategy;
                source = spec.getSource();
                BuildStrategy strategy = spec.getStrategy();
                if (strategy != null && (jenkinsPipelineStrategy = strategy.getJenkinsPipelineStrategy()) != null) {
                    jenkinsfile = jenkinsPipelineStrategy.getJenkinsfile();
                    jenkinsfilePath = jenkinsPipelineStrategy.getJenkinsfilePath();
                }
            }
            if (jenkinsfile == null) {
                if (source != null && source.getGit() != null && source.getGit().getUri() != null) {
                    void var9_11;
                    if (jenkinsfilePath == null) {
                        jenkinsfilePath = DEFAULT_JENKINS_FILEPATH;
                    }
                    if (!StringUtils.isEmpty((String)source.getContextDir())) {
                        jenkinsfilePath = new File(source.getContextDir(), jenkinsfilePath).getPath();
                    }
                    GitBuildSource gitSource = source.getGit();
                    String branchRef = gitSource.getRef();
                    List list = Collections.emptyList();
                    if (StringUtils.isNotBlank((String)branchRef)) {
                        List<BranchSpec> list2 = Collections.singletonList(new BranchSpec(branchRef));
                    }
                    GitSCM scm = new GitSCM(Collections.singletonList(new UserRemoteConfig(gitSource.getUri(), null, null, null)), (List)var9_11, Boolean.valueOf(false), Collections.emptyList(), null, null, null);
                    job.setDefinition((FlowDefinition)new CpsScmFlowDefinition((SCM)scm, jenkinsfilePath));
                    break block9;
                } else {
                    LOGGER.warning("BuildConfig does not contain source repository information - cannot map BuildConfig to Jenkins job");
                    return null;
                }
            }
            job.setDefinition((FlowDefinition)new CpsFlowDefinition(jenkinsfile));
        }
        job.addTrigger((Trigger)new BuildTrigger());
        return job;
    }

    public static boolean updateBuildConfigFromJob(WorkflowJob job, BuildConfig buildConfig) {
        BuildStrategy strategy;
        NamespaceName namespaceName = NamespaceName.create((HasMetadata)buildConfig);
        JenkinsPipelineBuildStrategy jenkinsPipelineStrategy = null;
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec != null && (strategy = spec.getStrategy()) != null) {
            jenkinsPipelineStrategy = strategy.getJenkinsPipelineStrategy();
        }
        if (jenkinsPipelineStrategy == null) {
            LOGGER.warning("No jenkinsPipelineStrategy available in the BuildConfig " + namespaceName);
            return false;
        }
        FlowDefinition definition = job.getDefinition();
        if (definition instanceof CpsScmFlowDefinition) {
            CpsScmFlowDefinition cpsScmFlowDefinition = (CpsScmFlowDefinition)definition;
            String scriptPath = cpsScmFlowDefinition.getScriptPath();
            if (scriptPath != null && scriptPath.trim().length() > 0) {
                URIish urIish;
                String gitUrl;
                RemoteConfig remoteConfig;
                List urIs;
                GitSCM gitSCM;
                List repositories;
                jenkinsPipelineStrategy.setJenkinsfilePath(scriptPath);
                SCM scm = cpsScmFlowDefinition.getScm();
                if (scm instanceof GitSCM && (repositories = (gitSCM = (GitSCM)scm).getRepositories()) != null && repositories.size() > 0 && (urIs = (remoteConfig = (RemoteConfig)repositories.get(0)).getURIs()) != null && urIs.size() > 0 && (gitUrl = (urIish = (URIish)urIs.get(0)).toString()) != null && gitUrl.length() > 0) {
                    List branches = gitSCM.getBranches();
                    if (branches != null && branches.size() > 0) {
                        BranchSpec branchSpec = (BranchSpec)branches.get(0);
                        String branch = branchSpec.getName();
                        while (branch.startsWith("*") || branch.startsWith("/")) {
                            branch = branch.substring(1);
                        }
                    }
                    String ref = null;
                    OpenShiftUtils.updateGitSourceUrl(buildConfig, gitUrl, ref);
                }
                return true;
            }
            return false;
        }
        if (definition instanceof CpsFlowDefinition) {
            CpsFlowDefinition cpsFlowDefinition = (CpsFlowDefinition)definition;
            String jenkinsfile = cpsFlowDefinition.getScript();
            if (jenkinsfile != null && jenkinsfile.trim().length() > 0) {
                jenkinsPipelineStrategy.setJenkinsfile(jenkinsfile);
                return true;
            }
            return false;
        }
        LOGGER.warning("Cannot update BuildConfig " + namespaceName + " as the definition is of class " + (definition == null ? "null" : definition.getClass().getName()));
        return false;
    }
}

