/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.openshift.api.model.BuildConfig;
import jenkins.model.ParameterizedJobMixIn;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildConfigProjectProperty
extends JobProperty<Job<?, ?>> {
    private BuildConfig buildConfig;

    @DataBoundConstructor
    public BuildConfigProjectProperty(String buildConfigAsXML) {
        if (StringUtils.isNotBlank((String)buildConfigAsXML)) {
            this.buildConfig = (BuildConfig)JenkinsUtils.xstream2().fromXML(buildConfigAsXML);
        }
    }

    public BuildConfigProjectProperty(BuildConfig buildConfig) {
        this.buildConfig = buildConfig;
    }

    public BuildConfig getBuildConfig() {
        return this.buildConfig;
    }

    public String getBuildConfigAsXML() {
        if (this.buildConfig == null) {
            return null;
        }
        return JenkinsUtils.xstream2().toXML((Object)this.buildConfig);
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public static final String OPENSHIFT_BUILDCONFIG_BLOCK_NAME = "openshiftBuildConfig";

        public boolean isApplicable(Class<? extends Job> jobType) {
            return ParameterizedJobMixIn.ParameterizedJob.class.isAssignableFrom(jobType);
        }
    }
}

