/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.model.Cause;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSpec;
import org.apache.commons.lang.StringUtils;

public class BuildCause
extends Cause {
    private final Build build;

    public BuildCause(Build build) {
        this.build = build;
    }

    public Build getBuild() {
        return this.build;
    }

    public String getShortDescription() {
        BuildSource source;
        StringBuilder sb = new StringBuilder("OpenShift Build ").append(this.build.getMetadata().getNamespace()).append("/").append(this.build.getMetadata().getName());
        BuildSpec spec = this.build.getSpec();
        if (spec != null && (source = spec.getSource()) != null && source.getGit() != null && StringUtils.isNotBlank((String)source.getGit().getUri())) {
            sb.append(" from ").append(source.getGit().getUri());
            if (spec.getRevision() != null && spec.getRevision().getGit() != null && StringUtils.isNotBlank((String)spec.getRevision().getGit().getCommit())) {
                sb.append(", commit ").append(spec.getRevision().getGit().getCommit());
            }
        }
        return sb.toString();
    }
}

