/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewFluent;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewFluent;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientSubjectAccessReviewOperation;
import io.fabric8.openshift.client.dsl.CreateableLocalSubjectAccessReview;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;

public class ClientSubjectAccessReviewOperationImpl
extends OperationSupport<OpenShiftClient>
implements ClientSubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> {
    public ClientSubjectAccessReviewOperationImpl(OpenShiftClient client) {
        this(client, null);
    }

    public ClientSubjectAccessReviewOperationImpl(OpenShiftClient client, String namespace) {
        super(client, "subjectaccessreviews", namespace, null);
    }

    @Override
    public CreateableLocalSubjectAccessReview inNamespace(String namespace) {
        return new ClientSubjectAccessReviewOperationImpl((OpenShiftClient)this.getClient(), namespace).local();
    }

    public SubjectAccessReviewResponse create(SubjectAccessReview ... item) {
        return new CreateableSubjectAccessReviewImpl((OpenShiftClient)this.getClient()).create(item);
    }

    @Override
    public CreateableSubjectAccessReview createNew() {
        return new CreateableSubjectAccessReviewImpl((OpenShiftClient)this.getClient()).createNew();
    }

    @Override
    public URL getRootUrl() {
        return ((OpenShiftClient)this.getClient()).getOpenshiftUrl();
    }

    private CreateableLocalSubjectAccessReview local() {
        return new CreateableLocalSubjectAccessReviewImpl((OpenShiftClient)this.getClient());
    }

    private class CreateableSubjectAccessReviewImpl
    extends CreateableSubjectAccessReview {
        private final OpenShiftClient client;
        private final SubjectAccessReviewBuilder builder;

        private CreateableSubjectAccessReviewImpl(OpenShiftClient client) {
            this.client = client;
            this.builder = new SubjectAccessReviewBuilder((SubjectAccessReviewFluent)this);
        }

        private CreateableSubjectAccessReviewImpl(OpenShiftClient client, SubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        public SubjectAccessReviewResponse create(SubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)ClientSubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public CreateableSubjectAccessReview createNew() {
            return this;
        }

        public SubjectAccessReviewResponse done() {
            return this.create(new SubjectAccessReview[]{this.builder.build()});
        }
    }

    private class CreateableLocalSubjectAccessReviewImpl
    extends CreateableLocalSubjectAccessReview {
        private final OpenShiftClient client;
        private final LocalSubjectAccessReviewBuilder builder;

        private CreateableLocalSubjectAccessReviewImpl(OpenShiftClient client) {
            this.client = client;
            this.builder = new LocalSubjectAccessReviewBuilder((LocalSubjectAccessReviewFluent)this);
        }

        private CreateableLocalSubjectAccessReviewImpl(OpenShiftClient client, LocalSubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        public SubjectAccessReviewResponse create(LocalSubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)ClientSubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public CreateableLocalSubjectAccessReview createNew() {
            return this;
        }

        public SubjectAccessReviewResponse done() {
            return this.create(new LocalSubjectAccessReview[]{this.builder.build()});
        }
    }
}

