/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.EditableNamespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.NodeListBuilder;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import io.fabric8.kubernetes.server.mock.Returnable;
import io.fabric8.kubernetes.server.mock.Timeable;
import org.junit.Assert;
import org.junit.Test;

public class NodeTest
extends KubernetesMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/nodes")).andReturn(200, ((NodeListBuilder)new NodeListBuilder().addNewItem().and()).build())).once();
        KubernetesClient client = this.getClient();
        NodeList nodeList = (NodeList)client.nodes().list();
        Assert.assertNotNull((Object)nodeList);
        Assert.assertEquals((long)1L, (long)nodeList.getItems().size());
    }

    @Test
    public void testGet() {
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/nodes/node1")).andReturn(200, new PodBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/nodes/node2")).andReturn(200, new PodBuilder().build())).once();
        KubernetesClient client = this.getClient();
        Node node = (Node)((ClientResource)client.nodes().withName("node1")).get();
        Assert.assertNotNull((Object)node);
        node = (Node)((ClientResource)client.nodes().withName("node2")).get();
        Assert.assertNotNull((Object)node);
        node = (Node)((ClientResource)client.nodes().withName("node3")).get();
        Assert.assertNull((Object)node);
    }

    @Test
    public void testDelete() {
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/nodes/node1")).andReturn(200, new PodBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/nodes/node2")).andReturn(200, new PodBuilder().build())).once();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientResource)client.nodes().withName("node1")).delete();
        Assert.assertTrue((boolean)deleted);
        deleted = (Boolean)((ClientResource)client.nodes().withName("node2")).delete();
        Assert.assertTrue((boolean)deleted);
        deleted = (Boolean)((ClientResource)client.nodes().withName("node3")).delete();
        Assert.assertFalse((boolean)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testCreateWithNameMismatch() {
        EditableNamespace ns1 = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("ns1")).and()).build();
        KubernetesClient client = this.getClient();
        ((ClientResource)client.namespaces().withName("myns1")).create(ns1);
    }
}

