/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.EditablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientLoggableResource;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class PodTest
extends KubernetesMockServerTestBase {
    @Test
    public void testList() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/pods", 200, new PodListBuilder().build());
        this.expectAndReturnAsJson("/api/v1/namespaces/ns1/pods", 200, ((PodListBuilder)((PodListBuilder)new PodListBuilder().addNewItem().and()).addNewItem().and()).build());
        this.expectAndReturnAsJson("/api/v1/pods", 200, ((PodListBuilder)((PodListBuilder)((PodListBuilder)new PodListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build());
        KubernetesClient client = this.getClient();
        PodList podList = (PodList)client.pods().list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)0L, (long)podList.getItems().size());
        podList = (PodList)((ClientNonNamespaceOperation)client.pods().inNamespace("ns1")).list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)2L, (long)podList.getItems().size());
        podList = (PodList)((FilterWatchListMultiDeletable)client.pods().inAnyNamespace()).list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)3L, (long)podList.getItems().size());
    }

    @Test
    public void testListWithLables() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/pods?labelSelector=" + PodTest.toUrlEncoded("key1=value1,key2=value2,key3=value3"), 200, new PodListBuilder().build());
        this.expectAndReturnAsJson("/api/v1/namespaces/test/pods?labelSelector=" + PodTest.toUrlEncoded("key1=value1,key2=value2"), 200, ((PodListBuilder)((PodListBuilder)((PodListBuilder)new PodListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build());
        KubernetesClient client = this.getClient();
        PodList podList = (PodList)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)client.pods().withLabel("key1", "value1")).withLabel("key2", "value2")).withLabel("key3", "value3")).list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)0L, (long)podList.getItems().size());
        podList = (PodList)((FilterWatchListDeletable)((FilterWatchListDeletable)client.pods().withLabel("key1", "value1")).withLabel("key2", "value2")).list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)3L, (long)podList.getItems().size());
    }

    @Test
    public void testGet() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/pods/pod1", 200, new PodBuilder().build());
        this.expectAndReturnAsJson("/api/v1/namespaces/ns1/pods/pod2", 200, new PodBuilder().build());
        KubernetesClient client = this.getClient();
        Pod pod = (Pod)((ClientLoggableResource)client.pods().withName("pod1")).get();
        Assert.assertNotNull((Object)pod);
        pod = (Pod)((ClientLoggableResource)client.pods().withName("pod2")).get();
        Assert.assertNull((Object)pod);
        pod = (Pod)((ClientLoggableResource)((ClientNonNamespaceOperation)client.pods().inNamespace("ns1")).withName("pod2")).get();
        Assert.assertNotNull((Object)pod);
    }

    @Test
    public void testDelete() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/pods/pod1", 200, new PodBuilder().build());
        this.expectAndReturnAsJson("/api/v1/namespaces/ns1/pods/pod2", 200, new PodBuilder().build());
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientLoggableResource)client.pods().withName("pod1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientLoggableResource)client.pods().withName("pod2")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientLoggableResource)((ClientNonNamespaceOperation)client.pods().inNamespace("ns1")).withName("pod2")).delete();
        Assert.assertTrue((boolean)deleted);
    }

    @Test
    public void testDeleteMulti() {
        EditablePod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
        EditablePod pod2 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).withNamespace("ns1")).and()).build();
        EditablePod pod3 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod3")).withNamespace("any")).and()).build();
        this.expectAndReturnAsJson("/api/v1/namespaces/test/pods/pod1", 200, pod1);
        this.expectAndReturnAsJson("/api/v1/namespaces/ns1/pods/pod2", 200, pod2);
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((FilterWatchListMultiDeletable)client.pods().inAnyNamespace()).delete(pod1, pod2);
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((FilterWatchListMultiDeletable)client.pods().inAnyNamespace()).delete(pod3);
        Assert.assertFalse((boolean)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testDeleteWithNamespaceMismatch() {
        EditablePod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
        EditablePod pod2 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).withNamespace("ns1")).and()).build();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientNonNamespaceOperation)client.pods().inNamespace("test1")).delete(pod1);
        Assert.assertNotNull((Object)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testCreateWithNameMismatch() {
        EditablePod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
        EditablePod pod2 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).withNamespace("ns1")).and()).build();
        KubernetesClient client = this.getClient();
        ((ClientLoggableResource)((ClientNonNamespaceOperation)client.pods().inNamespace("test1")).withName("mypod1")).create(pod1);
    }

    @Test
    public void testGetLog() {
        String pod1Log = "pod1Log";
        String pod2Log = "pod2Log";
        String pod3Log = "pod3Log";
        String pod4Log = "pod4Log";
        this.expectAndReturnAsString("/api/v1/namespaces/test/pods/pod1/log?pretty=true", 200, pod1Log);
        this.expectAndReturnAsString("/api/v1/namespaces/test/pods/pod2/log?pretty=false", 200, pod2Log);
        this.expectAndReturnAsString("/api/v1/namespaces/test/pods/pod3/log?pretty=false&container=cnt3", 200, pod3Log);
        this.expectAndReturnAsString("/api/v1/namespaces/test4/pods/pod4/log?pretty=true&container=cnt4", 200, pod4Log);
        KubernetesClient client = this.getClient();
        String log = (String)((ClientLoggableResource)client.pods().withName("pod1")).getLog(true);
        Assert.assertEquals((Object)pod1Log, (Object)log);
        log = (String)((ClientLoggableResource)client.pods().withName("pod2")).getLog(false);
        Assert.assertEquals((Object)pod2Log, (Object)log);
        log = (String)((ClientLoggableResource)client.pods().withName("pod3")).getLog("cnt3", false);
        Assert.assertEquals((Object)pod3Log, (Object)log);
        log = (String)((ClientLoggableResource)((ClientNonNamespaceOperation)client.pods().inNamespace("test4")).withName("pod4")).getLog("cnt4", true);
        Assert.assertEquals((Object)pod4Log, (Object)log);
    }

    @Test(expected=KubernetesClientException.class)
    public void testGetLogNotFound() {
        KubernetesClient client = this.getClient();
        ((ClientLoggableResource)client.pods().withName("pod5")).getLog(true);
    }

    private static final String toUrlEncoded(String str) {
        return str.replaceAll("=", "%3D").replaceAll(",", "%2C");
    }
}

