/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.openshift.client.DefaultOpenshiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenshiftConfig;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class OpenshiftExtensionAdapter
implements ExtensionAdapter<OpenShiftClient> {
    private static final ConcurrentMap<URL, Boolean> IS_OPENSHIFT = new ConcurrentHashMap<URL, Boolean>();

    @Override
    public Class<OpenShiftClient> getExtensionType() {
        return OpenShiftClient.class;
    }

    @Override
    public OpenShiftClient adapt(Client client) {
        String customOpenshiftUrl = OpenshiftConfig.getCustomOpenshiftUrl();
        if ((customOpenshiftUrl == null || customOpenshiftUrl.isEmpty()) && !OpenshiftExtensionAdapter.isOpenShift(client)) {
            throw new IllegalArgumentException("Client is not pointing to an OpenShift installation");
        }
        return new DefaultOpenshiftClient((Config)client.getConfiguration());
    }

    public static boolean isOpenShift(Client client) {
        List paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_OPENSHIFT.containsKey(masterUrl)) {
            return (Boolean)IS_OPENSHIFT.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path)) continue;
                IS_OPENSHIFT.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_OPENSHIFT.putIfAbsent(masterUrl, false);
        return false;
    }
}

