package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenShiftConfigBuilder extends OpenShiftConfigFluent<OpenShiftConfigBuilder> implements VisitableBuilder<OpenShiftConfig,OpenShiftConfigBuilder>{
  public OpenShiftConfigBuilder() {
    this(false);
  }
  public OpenShiftConfigBuilder(Boolean validationEnabled) {
    this(new OpenShiftConfig(), validationEnabled);
  }
  public OpenShiftConfigBuilder(OpenShiftConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftConfigBuilder(OpenShiftConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenShiftConfig(), validationEnabled);
  }
  public OpenShiftConfigBuilder(OpenShiftConfigFluent<?> fluent,OpenShiftConfig instance) {
    this(fluent, instance, false);
  }
  public OpenShiftConfigBuilder(OpenShiftConfigFluent<?> fluent,OpenShiftConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OpenShiftConfig());

    if (instance != null) {
      fluent.withOpenShiftUrl(instance.getOpenShiftUrl());
      fluent.withOapiVersion(instance.getOapiVersion());
      fluent.withMasterUrl(instance.getMasterUrl());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withNamespace(instance.getNamespace());
      fluent.withTrustCerts(instance.isTrustCerts());
      fluent.withDisableHostnameVerification(instance.isDisableHostnameVerification());
      fluent.withCaCertFile(instance.getCaCertFile());
      fluent.withCaCertData(instance.getCaCertData());
      fluent.withClientCertFile(instance.getClientCertFile());
      fluent.withClientCertData(instance.getClientCertData());
      fluent.withClientKeyFile(instance.getClientKeyFile());
      fluent.withClientKeyData(instance.getClientKeyData());
      fluent.withClientKeyAlgo(instance.getClientKeyAlgo());
      fluent.withClientKeyPassphrase(instance.getClientKeyPassphrase());
      fluent.withUsername(instance.getUsername());
      fluent.withPassword(instance.getPassword());
      fluent.withOauthToken(instance.getOauthToken());
      fluent.withAutoOAuthToken(instance.getAutoOAuthToken());
      fluent.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      fluent.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      fluent.withConnectionTimeout(instance.getConnectionTimeout());
      fluent.withRequestTimeout(instance.getRequestTimeout());
      fluent.withScaleTimeout(instance.getScaleTimeout());
      fluent.withLoggingInterval(instance.getLoggingInterval());
      fluent.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
      fluent.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
      fluent.withHttp2Disable(instance.isHttp2Disable());
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withErrorMessages(instance.getErrorMessages());
      fluent.withUserAgent(instance.getUserAgent());
      fluent.withTlsVersions(instance.getTlsVersions());
      fluent.withWebsocketPingInterval(instance.getWebsocketPingInterval());
      fluent.withProxyUsername(instance.getProxyUsername());
      fluent.withProxyPassword(instance.getProxyPassword());
      fluent.withTrustStoreFile(instance.getTrustStoreFile());
      fluent.withTrustStorePassphrase(instance.getTrustStorePassphrase());
      fluent.withKeyStoreFile(instance.getKeyStoreFile());
      fluent.withKeyStorePassphrase(instance.getKeyStorePassphrase());
      fluent.withImpersonateUsername(instance.getImpersonateUsername());
      fluent.withImpersonateGroups(instance.getImpersonateGroups());
      fluent.withImpersonateExtras(instance.getImpersonateExtras());
      fluent.withOauthTokenProvider(instance.getOauthTokenProvider());
      fluent.withCustomHeaders(instance.getCustomHeaders());
      fluent.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      fluent.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      fluent.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      fluent.withBuildTimeout(instance.getBuildTimeout());
      fluent.withDisableApiGroupCheck(instance.isDisableApiGroupCheck());
      fluent.withOapiVersion(instance.getOapiVersion());
      fluent.withOpenShiftUrl(instance.getOpenShiftUrl());
      fluent.withBuildTimeout(instance.getBuildTimeout());
      fluent.withDisableApiGroupCheck(instance.isDisableApiGroupCheck());
      fluent.withTrustCerts(instance.isTrustCerts());
      fluent.withDisableHostnameVerification(instance.isDisableHostnameVerification());
      fluent.withMasterUrl(instance.getMasterUrl());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withNamespace(instance.getNamespace());
      fluent.withDefaultNamespace(instance.isDefaultNamespace());
      fluent.withCaCertFile(instance.getCaCertFile());
      fluent.withCaCertData(instance.getCaCertData());
      fluent.withClientCertFile(instance.getClientCertFile());
      fluent.withClientCertData(instance.getClientCertData());
      fluent.withClientKeyFile(instance.getClientKeyFile());
      fluent.withClientKeyData(instance.getClientKeyData());
      fluent.withClientKeyAlgo(instance.getClientKeyAlgo());
      fluent.withClientKeyPassphrase(instance.getClientKeyPassphrase());
      fluent.withTrustStoreFile(instance.getTrustStoreFile());
      fluent.withTrustStorePassphrase(instance.getTrustStorePassphrase());
      fluent.withKeyStoreFile(instance.getKeyStoreFile());
      fluent.withKeyStorePassphrase(instance.getKeyStorePassphrase());
      fluent.withAuthProvider(instance.getAuthProvider());
      fluent.withUsername(instance.getUsername());
      fluent.withPassword(instance.getPassword());
      fluent.withOauthToken(instance.getOauthToken());
      fluent.withAutoOAuthToken(instance.getAutoOAuthToken());
      fluent.withOauthTokenProvider(instance.getOauthTokenProvider());
      fluent.withWebsocketPingInterval(instance.getWebsocketPingInterval());
      fluent.withConnectionTimeout(instance.getConnectionTimeout());
      fluent.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
      fluent.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
      fluent.withContexts(instance.getContexts());
      fluent.withCurrentContext(instance.getCurrentContext());
      fluent.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      fluent.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      fluent.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      fluent.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      fluent.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      fluent.withRequestTimeout(instance.getRequestTimeout());
      fluent.withScaleTimeout(instance.getScaleTimeout());
      fluent.withLoggingInterval(instance.getLoggingInterval());
      fluent.withImpersonateUsername(instance.getImpersonateUsername());
      fluent.withImpersonateGroups(instance.getImpersonateGroups());
      fluent.withImpersonateExtras(instance.getImpersonateExtras());
      fluent.withHttp2Disable(instance.isHttp2Disable());
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withProxyUsername(instance.getProxyUsername());
      fluent.withProxyPassword(instance.getProxyPassword());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withUserAgent(instance.getUserAgent());
      fluent.withTlsVersions(instance.getTlsVersions());
      fluent.withErrorMessages(instance.getErrorMessages());
      fluent.withCustomHeaders(instance.getCustomHeaders());
      fluent.withAutoConfigure(instance.getAutoConfigure());
      fluent.withFile(instance.getFile());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftConfigBuilder(OpenShiftConfig instance) {
    this(instance,false);
  }
  public OpenShiftConfigBuilder(OpenShiftConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OpenShiftConfig());

    if (instance != null) {
      this.withOpenShiftUrl(instance.getOpenShiftUrl());
      this.withOapiVersion(instance.getOapiVersion());
      this.withMasterUrl(instance.getMasterUrl());
      this.withApiVersion(instance.getApiVersion());
      this.withNamespace(instance.getNamespace());
      this.withTrustCerts(instance.isTrustCerts());
      this.withDisableHostnameVerification(instance.isDisableHostnameVerification());
      this.withCaCertFile(instance.getCaCertFile());
      this.withCaCertData(instance.getCaCertData());
      this.withClientCertFile(instance.getClientCertFile());
      this.withClientCertData(instance.getClientCertData());
      this.withClientKeyFile(instance.getClientKeyFile());
      this.withClientKeyData(instance.getClientKeyData());
      this.withClientKeyAlgo(instance.getClientKeyAlgo());
      this.withClientKeyPassphrase(instance.getClientKeyPassphrase());
      this.withUsername(instance.getUsername());
      this.withPassword(instance.getPassword());
      this.withOauthToken(instance.getOauthToken());
      this.withAutoOAuthToken(instance.getAutoOAuthToken());
      this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      this.withConnectionTimeout(instance.getConnectionTimeout());
      this.withRequestTimeout(instance.getRequestTimeout());
      this.withScaleTimeout(instance.getScaleTimeout());
      this.withLoggingInterval(instance.getLoggingInterval());
      this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
      this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
      this.withHttp2Disable(instance.isHttp2Disable());
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
      this.withErrorMessages(instance.getErrorMessages());
      this.withUserAgent(instance.getUserAgent());
      this.withTlsVersions(instance.getTlsVersions());
      this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
      this.withProxyUsername(instance.getProxyUsername());
      this.withProxyPassword(instance.getProxyPassword());
      this.withTrustStoreFile(instance.getTrustStoreFile());
      this.withTrustStorePassphrase(instance.getTrustStorePassphrase());
      this.withKeyStoreFile(instance.getKeyStoreFile());
      this.withKeyStorePassphrase(instance.getKeyStorePassphrase());
      this.withImpersonateUsername(instance.getImpersonateUsername());
      this.withImpersonateGroups(instance.getImpersonateGroups());
      this.withImpersonateExtras(instance.getImpersonateExtras());
      this.withOauthTokenProvider(instance.getOauthTokenProvider());
      this.withCustomHeaders(instance.getCustomHeaders());
      this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      this.withBuildTimeout(instance.getBuildTimeout());
      this.withDisableApiGroupCheck(instance.isDisableApiGroupCheck());
      this.withOapiVersion(instance.getOapiVersion());
      this.withOpenShiftUrl(instance.getOpenShiftUrl());
      this.withBuildTimeout(instance.getBuildTimeout());
      this.withDisableApiGroupCheck(instance.isDisableApiGroupCheck());
      this.withTrustCerts(instance.isTrustCerts());
      this.withDisableHostnameVerification(instance.isDisableHostnameVerification());
      this.withMasterUrl(instance.getMasterUrl());
      this.withApiVersion(instance.getApiVersion());
      this.withNamespace(instance.getNamespace());
      this.withDefaultNamespace(instance.isDefaultNamespace());
      this.withCaCertFile(instance.getCaCertFile());
      this.withCaCertData(instance.getCaCertData());
      this.withClientCertFile(instance.getClientCertFile());
      this.withClientCertData(instance.getClientCertData());
      this.withClientKeyFile(instance.getClientKeyFile());
      this.withClientKeyData(instance.getClientKeyData());
      this.withClientKeyAlgo(instance.getClientKeyAlgo());
      this.withClientKeyPassphrase(instance.getClientKeyPassphrase());
      this.withTrustStoreFile(instance.getTrustStoreFile());
      this.withTrustStorePassphrase(instance.getTrustStorePassphrase());
      this.withKeyStoreFile(instance.getKeyStoreFile());
      this.withKeyStorePassphrase(instance.getKeyStorePassphrase());
      this.withAuthProvider(instance.getAuthProvider());
      this.withUsername(instance.getUsername());
      this.withPassword(instance.getPassword());
      this.withOauthToken(instance.getOauthToken());
      this.withAutoOAuthToken(instance.getAutoOAuthToken());
      this.withOauthTokenProvider(instance.getOauthTokenProvider());
      this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
      this.withConnectionTimeout(instance.getConnectionTimeout());
      this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
      this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
      this.withContexts(instance.getContexts());
      this.withCurrentContext(instance.getCurrentContext());
      this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      this.withRequestTimeout(instance.getRequestTimeout());
      this.withScaleTimeout(instance.getScaleTimeout());
      this.withLoggingInterval(instance.getLoggingInterval());
      this.withImpersonateUsername(instance.getImpersonateUsername());
      this.withImpersonateGroups(instance.getImpersonateGroups());
      this.withImpersonateExtras(instance.getImpersonateExtras());
      this.withHttp2Disable(instance.isHttp2Disable());
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withProxyUsername(instance.getProxyUsername());
      this.withProxyPassword(instance.getProxyPassword());
      this.withNoProxy(instance.getNoProxy());
      this.withUserAgent(instance.getUserAgent());
      this.withTlsVersions(instance.getTlsVersions());
      this.withErrorMessages(instance.getErrorMessages());
      this.withCustomHeaders(instance.getCustomHeaders());
      this.withAutoConfigure(instance.getAutoConfigure());
      this.withFile(instance.getFile());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenShiftConfigFluent<?> fluent;
  Boolean validationEnabled;
  public OpenShiftConfig build() {
    OpenShiftConfig buildable = new OpenShiftConfig(fluent.getOpenShiftUrl(),fluent.getOapiVersion(),fluent.getMasterUrl(),fluent.getApiVersion(),fluent.getNamespace(),fluent.isTrustCerts(),fluent.isDisableHostnameVerification(),fluent.getCaCertFile(),fluent.getCaCertData(),fluent.getClientCertFile(),fluent.getClientCertData(),fluent.getClientKeyFile(),fluent.getClientKeyData(),fluent.getClientKeyAlgo(),fluent.getClientKeyPassphrase(),fluent.getUsername(),fluent.getPassword(),fluent.getOauthToken(),fluent.getAutoOAuthToken(),fluent.getWatchReconnectInterval(),fluent.getWatchReconnectLimit(),fluent.getConnectionTimeout(),fluent.getRequestTimeout(),fluent.getScaleTimeout(),fluent.getLoggingInterval(),fluent.getMaxConcurrentRequests(),fluent.getMaxConcurrentRequestsPerHost(),fluent.isHttp2Disable(),fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getErrorMessages(),fluent.getUserAgent(),fluent.getTlsVersions(),fluent.getWebsocketPingInterval(),fluent.getProxyUsername(),fluent.getProxyPassword(),fluent.getTrustStoreFile(),fluent.getTrustStorePassphrase(),fluent.getKeyStoreFile(),fluent.getKeyStorePassphrase(),fluent.getImpersonateUsername(),fluent.getImpersonateGroups(),fluent.getImpersonateExtras(),fluent.getOauthTokenProvider(),fluent.getCustomHeaders(),fluent.getRequestRetryBackoffLimit(),fluent.getRequestRetryBackoffInterval(),fluent.getUploadRequestTimeout(),fluent.getBuildTimeout(),fluent.isDisableApiGroupCheck());
    buildable.setDefaultNamespace(fluent.isDefaultNamespace());
    buildable.setAuthProvider(fluent.getAuthProvider());
    buildable.setContexts(fluent.getContexts());
    buildable.setCurrentContext(fluent.getCurrentContext());
    buildable.setAutoConfigure(fluent.isAutoConfigure());
    buildable.setFile(fluent.getFile());
    return buildable;
  }
  
}