package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenShiftConfigBuilder extends OpenShiftConfigFluent<OpenShiftConfigBuilder> implements VisitableBuilder<OpenShiftConfig,OpenShiftConfigBuilder>{
  public OpenShiftConfigBuilder() {
    this(new OpenShiftConfig());
  }
  
  public OpenShiftConfigBuilder(OpenShiftConfigFluent<?> fluent) {
    this(fluent, new OpenShiftConfig());
  }
  
  public OpenShiftConfigBuilder(OpenShiftConfigFluent<?> fluent,OpenShiftConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenShiftConfigBuilder(OpenShiftConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenShiftConfigFluent<?> fluent;
  
  public OpenShiftConfig build() {
    OpenShiftConfig buildable = new OpenShiftConfig(fluent.getOpenShiftUrl(),fluent.getOapiVersion(),fluent.getMasterUrl(),fluent.getApiVersion(),fluent.getNamespace(),fluent.isTrustCerts(),fluent.isDisableHostnameVerification(),fluent.getCaCertFile(),fluent.getCaCertData(),fluent.getClientCertFile(),fluent.getClientCertData(),fluent.getClientKeyFile(),fluent.getClientKeyData(),fluent.getClientKeyAlgo(),fluent.getClientKeyPassphrase(),fluent.getUsername(),fluent.getPassword(),fluent.getOauthToken(),fluent.getAutoOAuthToken(),fluent.getWatchReconnectInterval(),fluent.getWatchReconnectLimit(),fluent.getConnectionTimeout(),fluent.getRequestTimeout(),fluent.getScaleTimeout(),fluent.getLoggingInterval(),fluent.getMaxConcurrentRequests(),fluent.getMaxConcurrentRequestsPerHost(),fluent.isHttp2Disable(),fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getErrorMessages(),fluent.getUserAgent(),fluent.getTlsVersions(),fluent.getWebsocketPingInterval(),fluent.getProxyUsername(),fluent.getProxyPassword(),fluent.getTrustStoreFile(),fluent.getTrustStorePassphrase(),fluent.getKeyStoreFile(),fluent.getKeyStorePassphrase(),fluent.getImpersonateUsername(),fluent.getImpersonateGroups(),fluent.getImpersonateExtras(),fluent.getOauthTokenProvider(),fluent.getCustomHeaders(),fluent.getRequestRetryBackoffLimit(),fluent.getRequestRetryBackoffInterval(),fluent.getUploadRequestTimeout(),fluent.isOnlyHttpWatches(),fluent.getBuildTimeout(),fluent.isDisableApiGroupCheck());
    buildable.setDefaultNamespace(fluent.isDefaultNamespace());
    buildable.setAuthProvider(fluent.getAuthProvider());
    buildable.setContexts(fluent.getContexts());
    buildable.setCurrentContext(fluent.getCurrentContext());
    buildable.setAutoConfigure(fluent.isAutoConfigure());
    buildable.setFile(fluent.getFile());
    return buildable;
  }
  

}