/*
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.fabric8.openshift.client;

/**
 * Defines constants for all the OpenShift API Groups
 */
public class OpenShiftAPIGroups {
  private OpenShiftAPIGroups() {
    throw new IllegalStateException("Utility class");
  }

  public static final String AUTHORIZATION = "authorization.openshift.io";
  public static final String BUILD = "build.openshift.io";
  public static final String APPS = "apps.openshift.io";
  public static final String TEMPLATE = "template.openshift.io";
  public static final String IMAGE = "image.openshift.io";
  public static final String PROJECT = "project.openshift.io";
  public static final String USER = "user.openshift.io";
  public static final String OAUTH = "oauth.openshift.io";
  public static final String NETWORK = "network.openshift.io";
  public static final String ROUTE = "route.openshift.io";
  public static final String QUOTA = "quota.openshift.io";
  public static final String SECURITY = "security.openshift.io";
}
