package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ExternalNetworkSourceBuilder extends ExternalNetworkSourceFluent<ExternalNetworkSourceBuilder> implements VisitableBuilder<ExternalNetworkSource,ExternalNetworkSourceBuilder>{
  public ExternalNetworkSourceBuilder() {
    this(new ExternalNetworkSource());
  }
  
  public ExternalNetworkSourceBuilder(ExternalNetworkSourceFluent<?> fluent) {
    this(fluent, new ExternalNetworkSource());
  }
  
  public ExternalNetworkSourceBuilder(ExternalNetworkSourceFluent<?> fluent,ExternalNetworkSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ExternalNetworkSourceBuilder(ExternalNetworkSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ExternalNetworkSourceFluent<?> fluent;
  
  public ExternalNetworkSource build() {
    ExternalNetworkSource buildable = new ExternalNetworkSource(fluent.buildNamespaceSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}