package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EgressServiceStatusBuilder extends EgressServiceStatusFluent<EgressServiceStatusBuilder> implements VisitableBuilder<EgressServiceStatus,EgressServiceStatusBuilder>{
  public EgressServiceStatusBuilder() {
    this(new EgressServiceStatus());
  }
  
  public EgressServiceStatusBuilder(EgressServiceStatusFluent<?> fluent) {
    this(fluent, new EgressServiceStatus());
  }
  
  public EgressServiceStatusBuilder(EgressServiceStatusFluent<?> fluent,EgressServiceStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EgressServiceStatusBuilder(EgressServiceStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EgressServiceStatusFluent<?> fluent;
  
  public EgressServiceStatus build() {
    EgressServiceStatus buildable = new EgressServiceStatus(fluent.getHost());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}