package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EgressIPStatusFluent<A extends EgressIPStatusFluent<A>> extends BaseFluent<A>{
  public EgressIPStatusFluent() {
  }
  
  public EgressIPStatusFluent(EgressIPStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<EgressIPStatusItemBuilder> items = new ArrayList<EgressIPStatusItemBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EgressIPStatus instance) {
    instance = (instance != null ? instance : new EgressIPStatus());
    if (instance != null) {
          this.withItems(instance.getItems());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToItems(int index,EgressIPStatusItem item) {
    if (this.items == null) {this.items = new ArrayList<EgressIPStatusItemBuilder>();}
    EgressIPStatusItemBuilder builder = new EgressIPStatusItemBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  
  public A setToItems(int index,EgressIPStatusItem item) {
    if (this.items == null) {this.items = new ArrayList<EgressIPStatusItemBuilder>();}
    EgressIPStatusItemBuilder builder = new EgressIPStatusItemBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  
  public A addToItems(io.fabric8.kubernetes.api.model.ovn.v1.EgressIPStatusItem... items) {
    if (this.items == null) {this.items = new ArrayList<EgressIPStatusItemBuilder>();}
    for (EgressIPStatusItem item : items) {EgressIPStatusItemBuilder builder = new EgressIPStatusItemBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A addAllToItems(Collection<EgressIPStatusItem> items) {
    if (this.items == null) {this.items = new ArrayList<EgressIPStatusItemBuilder>();}
    for (EgressIPStatusItem item : items) {EgressIPStatusItemBuilder builder = new EgressIPStatusItemBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A removeFromItems(io.fabric8.kubernetes.api.model.ovn.v1.EgressIPStatusItem... items) {
    if (this.items == null) return (A)this;
    for (EgressIPStatusItem item : items) {EgressIPStatusItemBuilder builder = new EgressIPStatusItemBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeAllFromItems(Collection<EgressIPStatusItem> items) {
    if (this.items == null) return (A)this;
    for (EgressIPStatusItem item : items) {EgressIPStatusItemBuilder builder = new EgressIPStatusItemBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromItems(Predicate<EgressIPStatusItemBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<EgressIPStatusItemBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      EgressIPStatusItemBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EgressIPStatusItem> buildItems() {
    return this.items != null ? build(items) : null;
  }
  
  public EgressIPStatusItem buildItem(int index) {
    return this.items.get(index).build();
  }
  
  public EgressIPStatusItem buildFirstItem() {
    return this.items.get(0).build();
  }
  
  public EgressIPStatusItem buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  
  public EgressIPStatusItem buildMatchingItem(Predicate<EgressIPStatusItemBuilder> predicate) {
      for (EgressIPStatusItemBuilder item : items) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingItem(Predicate<EgressIPStatusItemBuilder> predicate) {
      for (EgressIPStatusItemBuilder item : items) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withItems(List<EgressIPStatusItem> items) {
    if (this.items != null) {
      this._visitables.get("items").clear();
    }
    if (items != null) {
        this.items = new ArrayList();
        for (EgressIPStatusItem item : items) {
          this.addToItems(item);
        }
    } else {
      this.items = null;
    }
    return (A) this;
  }
  
  public A withItems(io.fabric8.kubernetes.api.model.ovn.v1.EgressIPStatusItem... items) {
    if (this.items != null) {
        this.items.clear();
        _visitables.remove("items");
    }
    if (items != null) {
      for (EgressIPStatusItem item : items) {
        this.addToItems(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasItems() {
    return this.items != null && !this.items.isEmpty();
  }
  
  public A addNewItem(String egressIP,String node) {
    return (A)addToItems(new EgressIPStatusItem(egressIP, node));
  }
  
  public ItemsNested<A> addNewItem() {
    return new ItemsNested(-1, null);
  }
  
  public ItemsNested<A> addNewItemLike(EgressIPStatusItem item) {
    return new ItemsNested(-1, item);
  }
  
  public ItemsNested<A> setNewItemLike(int index,EgressIPStatusItem item) {
    return new ItemsNested(index, item);
  }
  
  public ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  
  public ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editMatchingItem(Predicate<EgressIPStatusItemBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EgressIPStatusFluent that = (EgressIPStatusFluent) o;
    if (!java.util.Objects.equals(items, that.items)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(items,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ItemsNested<N> extends EgressIPStatusItemFluent<ItemsNested<N>> implements Nested<N>{
    ItemsNested(int index,EgressIPStatusItem item) {
      this.index = index;
      this.builder = new EgressIPStatusItemBuilder(this, item);
    }
    EgressIPStatusItemBuilder builder;
    int index;
    
    public N and() {
      return (N) EgressIPStatusFluent.this.setToItems(index,builder.build());
    }
    
    public N endItem() {
      return and();
    }
    
  
  }

}