package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EgressFirewallSpecBuilder extends EgressFirewallSpecFluent<EgressFirewallSpecBuilder> implements VisitableBuilder<EgressFirewallSpec,EgressFirewallSpecBuilder>{
  public EgressFirewallSpecBuilder() {
    this(new EgressFirewallSpec());
  }
  
  public EgressFirewallSpecBuilder(EgressFirewallSpecFluent<?> fluent) {
    this(fluent, new EgressFirewallSpec());
  }
  
  public EgressFirewallSpecBuilder(EgressFirewallSpecFluent<?> fluent,EgressFirewallSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EgressFirewallSpecBuilder(EgressFirewallSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EgressFirewallSpecFluent<?> fluent;
  
  public EgressFirewallSpec build() {
    EgressFirewallSpec buildable = new EgressFirewallSpec(fluent.buildEgress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}