/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressQoSRule;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EgressQoSRuleFluent<A extends EgressQoSRuleFluent<A>>
extends BaseFluent<A> {
    private Integer dscp;
    private String dstCIDR;
    private LabelSelectorBuilder podSelector;
    private Map<String, Object> additionalProperties;

    public EgressQoSRuleFluent() {
    }

    public EgressQoSRuleFluent(EgressQoSRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EgressQoSRule instance) {
        EgressQoSRule egressQoSRule = instance = instance != null ? instance : new EgressQoSRule();
        if (instance != null) {
            this.withDscp(instance.getDscp());
            this.withDstCIDR(instance.getDstCIDR());
            this.withPodSelector(instance.getPodSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getDscp() {
        return this.dscp;
    }

    public A withDscp(Integer dscp) {
        this.dscp = dscp;
        return (A)((Object)this);
    }

    public boolean hasDscp() {
        return this.dscp != null;
    }

    public String getDstCIDR() {
        return this.dstCIDR;
    }

    public A withDstCIDR(String dstCIDR) {
        this.dstCIDR = dstCIDR;
        return (A)((Object)this);
    }

    public boolean hasDstCIDR() {
        return this.dstCIDR != null;
    }

    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.remove((Object)"podSelector");
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.get((Object)"podSelector").add(this.podSelector);
        } else {
            this.podSelector = null;
            this._visitables.get((Object)"podSelector").remove(this.podSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasPodSelector() {
        return this.podSelector != null;
    }

    public PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNested(null);
    }

    public PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNested(item);
    }

    public PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(null));
    }

    public PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EgressQoSRuleFluent that = (EgressQoSRuleFluent)((Object)o);
        if (!Objects.equals(this.dscp, that.dscp)) {
            return false;
        }
        if (!Objects.equals(this.dstCIDR, that.dstCIDR)) {
            return false;
        }
        if (!Objects.equals(this.podSelector, that.podSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.dscp, this.dstCIDR, this.podSelector, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dscp != null) {
            sb.append("dscp:");
            sb.append(this.dscp + ",");
        }
        if (this.dstCIDR != null) {
            sb.append("dstCIDR:");
            sb.append(this.dstCIDR + ",");
        }
        if (this.podSelector != null) {
            sb.append("podSelector:");
            sb.append(this.podSelector + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PodSelectorNested<N>
    extends LabelSelectorFluent<PodSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        PodSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)EgressQoSRuleFluent.this.withPodSelector(this.builder.build());
        }

        public N endPodSelector() {
            return this.and();
        }
    }
}

