package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EgressQoSSpecBuilder extends EgressQoSSpecFluent<EgressQoSSpecBuilder> implements VisitableBuilder<EgressQoSSpec,EgressQoSSpecBuilder>{
  public EgressQoSSpecBuilder() {
    this(new EgressQoSSpec());
  }
  
  public EgressQoSSpecBuilder(EgressQoSSpecFluent<?> fluent) {
    this(fluent, new EgressQoSSpec());
  }
  
  public EgressQoSSpecBuilder(EgressQoSSpecFluent<?> fluent,EgressQoSSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EgressQoSSpecBuilder(EgressQoSSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EgressQoSSpecFluent<?> fluent;
  
  public EgressQoSSpec build() {
    EgressQoSSpec buildable = new EgressQoSSpec(fluent.buildEgress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}