package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EgressIPSpecFluent<A extends EgressIPSpecFluent<A>> extends BaseFluent<A>{
  public EgressIPSpecFluent() {
  }
  
  public EgressIPSpecFluent(EgressIPSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> egressIPs = new ArrayList<String>();
  private LabelSelectorBuilder namespaceSelector;
  private LabelSelectorBuilder podSelector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EgressIPSpec instance) {
    instance = (instance != null ? instance : new EgressIPSpec());
    if (instance != null) {
          this.withEgressIPs(instance.getEgressIPs());
          this.withNamespaceSelector(instance.getNamespaceSelector());
          this.withPodSelector(instance.getPodSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToEgressIPs(int index,String item) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    this.egressIPs.add(index, item);
    return (A)this;
  }
  
  public A setToEgressIPs(int index,String item) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    this.egressIPs.set(index, item); return (A)this;
  }
  
  public A addToEgressIPs(java.lang.String... items) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    for (String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  
  public A addAllToEgressIPs(Collection<String> items) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    for (String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  
  public A removeFromEgressIPs(java.lang.String... items) {
    if (this.egressIPs == null) return (A)this;
    for (String item : items) { this.egressIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromEgressIPs(Collection<String> items) {
    if (this.egressIPs == null) return (A)this;
    for (String item : items) { this.egressIPs.remove(item);} return (A)this;
  }
  
  public List<String> getEgressIPs() {
    return this.egressIPs;
  }
  
  public String getEgressIP(int index) {
    return this.egressIPs.get(index);
  }
  
  public String getFirstEgressIP() {
    return this.egressIPs.get(0);
  }
  
  public String getLastEgressIP() {
    return this.egressIPs.get(egressIPs.size() - 1);
  }
  
  public String getMatchingEgressIP(Predicate<String> predicate) {
      for (String item : egressIPs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingEgressIP(Predicate<String> predicate) {
      for (String item : egressIPs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEgressIPs(List<String> egressIPs) {
    if (egressIPs != null) {
        this.egressIPs = new ArrayList();
        for (String item : egressIPs) {
          this.addToEgressIPs(item);
        }
    } else {
      this.egressIPs = null;
    }
    return (A) this;
  }
  
  public A withEgressIPs(java.lang.String... egressIPs) {
    if (this.egressIPs != null) {
        this.egressIPs.clear();
        _visitables.remove("egressIPs");
    }
    if (egressIPs != null) {
      for (String item : egressIPs) {
        this.addToEgressIPs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEgressIPs() {
    return this.egressIPs != null && !this.egressIPs.isEmpty();
  }
  
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
  }
  
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    this._visitables.remove("namespaceSelector");
    if (namespaceSelector != null) {
        this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
        this._visitables.get("namespaceSelector").add(this.namespaceSelector);
    } else {
        this.namespaceSelector = null;
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
    }
    return (A) this;
  }
  
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new NamespaceSelectorNested(item);
  }
  
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  
  public LabelSelector buildPodSelector() {
    return this.podSelector != null ? this.podSelector.build() : null;
  }
  
  public A withPodSelector(LabelSelector podSelector) {
    this._visitables.remove("podSelector");
    if (podSelector != null) {
        this.podSelector = new LabelSelectorBuilder(podSelector);
        this._visitables.get("podSelector").add(this.podSelector);
    } else {
        this.podSelector = null;
        this._visitables.get("podSelector").remove(this.podSelector);
    }
    return (A) this;
  }
  
  public boolean hasPodSelector() {
    return this.podSelector != null;
  }
  
  public PodSelectorNested<A> withNewPodSelector() {
    return new PodSelectorNested(null);
  }
  
  public PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
    return new PodSelectorNested(item);
  }
  
  public PodSelectorNested<A> editPodSelector() {
    return withNewPodSelectorLike(java.util.Optional.ofNullable(buildPodSelector()).orElse(null));
  }
  
  public PodSelectorNested<A> editOrNewPodSelector() {
    return withNewPodSelectorLike(java.util.Optional.ofNullable(buildPodSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
    return withNewPodSelectorLike(java.util.Optional.ofNullable(buildPodSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EgressIPSpecFluent that = (EgressIPSpecFluent) o;
    if (!java.util.Objects.equals(egressIPs, that.egressIPs)) return false;
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;
    if (!java.util.Objects.equals(podSelector, that.podSelector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(egressIPs,  namespaceSelector,  podSelector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (egressIPs != null && !egressIPs.isEmpty()) { sb.append("egressIPs:"); sb.append(egressIPs + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (podSelector != null) { sb.append("podSelector:"); sb.append(podSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NamespaceSelectorNested<N> extends LabelSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) EgressIPSpecFluent.this.withNamespaceSelector(builder.build());
    }
    
    public N endNamespaceSelector() {
      return and();
    }
    
  
  }
  public class PodSelectorNested<N> extends LabelSelectorFluent<PodSelectorNested<N>> implements Nested<N>{
    PodSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) EgressIPSpecFluent.this.withPodSelector(builder.build());
    }
    
    public N endPodSelector() {
      return and();
    }
    
  
  }

}