package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EgressFirewallBuilder extends EgressFirewallFluent<EgressFirewallBuilder> implements VisitableBuilder<EgressFirewall,EgressFirewallBuilder>{
  public EgressFirewallBuilder() {
    this(new EgressFirewall());
  }
  
  public EgressFirewallBuilder(EgressFirewallFluent<?> fluent) {
    this(fluent, new EgressFirewall());
  }
  
  public EgressFirewallBuilder(EgressFirewallFluent<?> fluent,EgressFirewall instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EgressFirewallBuilder(EgressFirewall instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EgressFirewallFluent<?> fluent;
  
  public EgressFirewall build() {
    EgressFirewall buildable = new EgressFirewall(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}