/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressQoSRule;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressQoSRuleBuilder;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressQoSRuleFluent;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressQoSSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EgressQoSSpecFluent<A extends EgressQoSSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<EgressQoSRuleBuilder> egress = new ArrayList();
    private Map<String, Object> additionalProperties;

    public EgressQoSSpecFluent() {
    }

    public EgressQoSSpecFluent(EgressQoSSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EgressQoSSpec instance) {
        EgressQoSSpec egressQoSSpec = instance = instance != null ? instance : new EgressQoSSpec();
        if (instance != null) {
            this.withEgress(instance.getEgress());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToEgress(int index, EgressQoSRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        EgressQoSRuleBuilder builder = new EgressQoSRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get((Object)"egress").add(index, builder);
            this.egress.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEgress(int index, EgressQoSRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        EgressQoSRuleBuilder builder = new EgressQoSRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get((Object)"egress").set(index, builder);
            this.egress.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEgress(EgressQoSRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (EgressQoSRule item : items) {
            EgressQoSRuleBuilder builder = new EgressQoSRuleBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEgress(Collection<EgressQoSRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (EgressQoSRule item : items) {
            EgressQoSRuleBuilder builder = new EgressQoSRuleBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEgress(EgressQoSRule ... items) {
        if (this.egress == null) {
            return (A)((Object)this);
        }
        for (EgressQoSRule item : items) {
            EgressQoSRuleBuilder builder = new EgressQoSRuleBuilder(item);
            this._visitables.get((Object)"egress").remove((Object)builder);
            this.egress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEgress(Collection<EgressQoSRule> items) {
        if (this.egress == null) {
            return (A)((Object)this);
        }
        for (EgressQoSRule item : items) {
            EgressQoSRuleBuilder builder = new EgressQoSRuleBuilder(item);
            this._visitables.get((Object)"egress").remove((Object)builder);
            this.egress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEgress(Predicate<EgressQoSRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)((Object)this);
        }
        Iterator<EgressQoSRuleBuilder> each = this.egress.iterator();
        List visitables = this._visitables.get((Object)"egress");
        while (each.hasNext()) {
            EgressQoSRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EgressQoSRule> buildEgress() {
        return this.egress != null ? EgressQoSSpecFluent.build(this.egress) : null;
    }

    public EgressQoSRule buildEgress(int index) {
        return this.egress.get(index).build();
    }

    public EgressQoSRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    public EgressQoSRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    public EgressQoSRule buildMatchingEgress(Predicate<EgressQoSRuleBuilder> predicate) {
        for (EgressQoSRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEgress(Predicate<EgressQoSRuleBuilder> predicate) {
        for (EgressQoSRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEgress(List<EgressQoSRule> egress) {
        if (this.egress != null) {
            this._visitables.get((Object)"egress").clear();
        }
        if (egress != null) {
            this.egress = new ArrayList();
            for (EgressQoSRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)((Object)this);
    }

    public A withEgress(EgressQoSRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
            this._visitables.remove((Object)"egress");
        }
        if (egress != null) {
            for (EgressQoSRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    public EgressNested<A> addNewEgress() {
        return new EgressNested(-1, null);
    }

    public EgressNested<A> addNewEgressLike(EgressQoSRule item) {
        return new EgressNested(-1, item);
    }

    public EgressNested<A> setNewEgressLike(int index, EgressQoSRule item) {
        return new EgressNested(index, item);
    }

    public EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    public EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editMatchingEgress(Predicate<EgressQoSRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.test(this.egress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EgressQoSSpecFluent that = (EgressQoSSpecFluent)((Object)o);
        if (!Objects.equals(this.egress, that.egress)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.egress, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egress != null && !this.egress.isEmpty()) {
            sb.append("egress:");
            sb.append(this.egress + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EgressNested<N>
    extends EgressQoSRuleFluent<EgressNested<N>>
    implements Nested<N> {
        EgressQoSRuleBuilder builder;
        int index;

        EgressNested(int index, EgressQoSRule item) {
            this.index = index;
            this.builder = new EgressQoSRuleBuilder(this, item);
        }

        public N and() {
            return (N)EgressQoSSpecFluent.this.setToEgress(this.index, this.builder.build());
        }

        public N endEgress() {
            return this.and();
        }
    }
}

