/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.ovn.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressFirewallDestination;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressFirewallDestinationBuilder;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressFirewallDestinationFluent;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressFirewallPort;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressFirewallPortBuilder;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressFirewallPortFluent;
import io.fabric8.kubernetes.api.model.ovn.v1.EgressFirewallRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EgressFirewallRuleFluent<A extends EgressFirewallRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<EgressFirewallPortBuilder> ports = new ArrayList();
    private EgressFirewallDestinationBuilder to;
    private String type;
    private Map<String, Object> additionalProperties;

    public EgressFirewallRuleFluent() {
    }

    public EgressFirewallRuleFluent(EgressFirewallRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EgressFirewallRule instance) {
        EgressFirewallRule egressFirewallRule = instance = instance != null ? instance : new EgressFirewallRule();
        if (instance != null) {
            this.withPorts(instance.getPorts());
            this.withTo(instance.getTo());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToPorts(int index, EgressFirewallPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EgressFirewallPortBuilder builder = new EgressFirewallPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPorts(int index, EgressFirewallPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EgressFirewallPortBuilder builder = new EgressFirewallPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(EgressFirewallPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EgressFirewallPort item : items) {
            EgressFirewallPortBuilder builder = new EgressFirewallPortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPorts(Collection<EgressFirewallPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EgressFirewallPort item : items) {
            EgressFirewallPortBuilder builder = new EgressFirewallPortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(EgressFirewallPort ... items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (EgressFirewallPort item : items) {
            EgressFirewallPortBuilder builder = new EgressFirewallPortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPorts(Collection<EgressFirewallPort> items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (EgressFirewallPort item : items) {
            EgressFirewallPortBuilder builder = new EgressFirewallPortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPorts(Predicate<EgressFirewallPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        Iterator<EgressFirewallPortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            EgressFirewallPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EgressFirewallPort> buildPorts() {
        return this.ports != null ? EgressFirewallRuleFluent.build(this.ports) : null;
    }

    public EgressFirewallPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public EgressFirewallPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public EgressFirewallPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public EgressFirewallPort buildMatchingPort(Predicate<EgressFirewallPortBuilder> predicate) {
        for (EgressFirewallPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<EgressFirewallPortBuilder> predicate) {
        for (EgressFirewallPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<EgressFirewallPort> ports) {
        if (this.ports != null) {
            this._visitables.get((Object)"ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (EgressFirewallPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)((Object)this);
    }

    public A withPorts(EgressFirewallPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove((Object)"ports");
        }
        if (ports != null) {
            for (EgressFirewallPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public A addNewPort(Integer port, String protocol) {
        return this.addToPorts(new EgressFirewallPort(port, protocol));
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(EgressFirewallPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, EgressFirewallPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<EgressFirewallPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public EgressFirewallDestination buildTo() {
        return this.to != null ? this.to.build() : null;
    }

    public A withTo(EgressFirewallDestination to) {
        this._visitables.remove((Object)"to");
        if (to != null) {
            this.to = new EgressFirewallDestinationBuilder(to);
            this._visitables.get((Object)"to").add(this.to);
        } else {
            this.to = null;
            this._visitables.get((Object)"to").remove((Object)this.to);
        }
        return (A)((Object)this);
    }

    public boolean hasTo() {
        return this.to != null;
    }

    public ToNested<A> withNewTo() {
        return new ToNested(null);
    }

    public ToNested<A> withNewToLike(EgressFirewallDestination item) {
        return new ToNested(item);
    }

    public ToNested<A> editTo() {
        return this.withNewToLike(Optional.ofNullable(this.buildTo()).orElse(null));
    }

    public ToNested<A> editOrNewTo() {
        return this.withNewToLike(Optional.ofNullable(this.buildTo()).orElse(new EgressFirewallDestinationBuilder().build()));
    }

    public ToNested<A> editOrNewToLike(EgressFirewallDestination item) {
        return this.withNewToLike(Optional.ofNullable(this.buildTo()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EgressFirewallRuleFluent that = (EgressFirewallRuleFluent)((Object)o);
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals((Object)this.to, (Object)that.to)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ports, this.to, this.type, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.to != null) {
            sb.append("to:");
            sb.append((Object)((Object)this.to) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ToNested<N>
    extends EgressFirewallDestinationFluent<ToNested<N>>
    implements Nested<N> {
        EgressFirewallDestinationBuilder builder;

        ToNested(EgressFirewallDestination item) {
            this.builder = new EgressFirewallDestinationBuilder(this, item);
        }

        public N and() {
            return (N)EgressFirewallRuleFluent.this.withTo(this.builder.build());
        }

        public N endTo() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends EgressFirewallPortFluent<PortsNested<N>>
    implements Nested<N> {
        EgressFirewallPortBuilder builder;
        int index;

        PortsNested(int index, EgressFirewallPort item) {
            this.index = index;
            this.builder = new EgressFirewallPortBuilder(this, item);
        }

        public N and() {
            return (N)EgressFirewallRuleFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

