package io.fabric8.kubernetes.api.model.ovn.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AdminPolicyBasedRouteStatusFluent<A extends AdminPolicyBasedRouteStatusFluent<A>> extends BaseFluent<A>{
  public AdminPolicyBasedRouteStatusFluent() {
  }
  
  public AdminPolicyBasedRouteStatusFluent(AdminPolicyBasedRouteStatus instance) {
    this.copyInstance(instance);
  }
  private String lastTransitionTime;
  private List<String> messages = new ArrayList<String>();
  private String status;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AdminPolicyBasedRouteStatus instance) {
    instance = (instance != null ? instance : new AdminPolicyBasedRouteStatus());
    if (instance != null) {
          this.withLastTransitionTime(instance.getLastTransitionTime());
          this.withMessages(instance.getMessages());
          this.withStatus(instance.getStatus());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getLastTransitionTime() {
    return this.lastTransitionTime;
  }
  
  public A withLastTransitionTime(String lastTransitionTime) {
    this.lastTransitionTime = lastTransitionTime;
    return (A) this;
  }
  
  public boolean hasLastTransitionTime() {
    return this.lastTransitionTime != null;
  }
  
  public A addToMessages(int index,String item) {
    if (this.messages == null) {this.messages = new ArrayList<String>();}
    this.messages.add(index, item);
    return (A)this;
  }
  
  public A setToMessages(int index,String item) {
    if (this.messages == null) {this.messages = new ArrayList<String>();}
    this.messages.set(index, item); return (A)this;
  }
  
  public A addToMessages(java.lang.String... items) {
    if (this.messages == null) {this.messages = new ArrayList<String>();}
    for (String item : items) {this.messages.add(item);} return (A)this;
  }
  
  public A addAllToMessages(Collection<String> items) {
    if (this.messages == null) {this.messages = new ArrayList<String>();}
    for (String item : items) {this.messages.add(item);} return (A)this;
  }
  
  public A removeFromMessages(java.lang.String... items) {
    if (this.messages == null) return (A)this;
    for (String item : items) { this.messages.remove(item);} return (A)this;
  }
  
  public A removeAllFromMessages(Collection<String> items) {
    if (this.messages == null) return (A)this;
    for (String item : items) { this.messages.remove(item);} return (A)this;
  }
  
  public List<String> getMessages() {
    return this.messages;
  }
  
  public String getMessage(int index) {
    return this.messages.get(index);
  }
  
  public String getFirstMessage() {
    return this.messages.get(0);
  }
  
  public String getLastMessage() {
    return this.messages.get(messages.size() - 1);
  }
  
  public String getMatchingMessage(Predicate<String> predicate) {
      for (String item : messages) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingMessage(Predicate<String> predicate) {
      for (String item : messages) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMessages(List<String> messages) {
    if (messages != null) {
        this.messages = new ArrayList();
        for (String item : messages) {
          this.addToMessages(item);
        }
    } else {
      this.messages = null;
    }
    return (A) this;
  }
  
  public A withMessages(java.lang.String... messages) {
    if (this.messages != null) {
        this.messages.clear();
        _visitables.remove("messages");
    }
    if (messages != null) {
      for (String item : messages) {
        this.addToMessages(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMessages() {
    return this.messages != null && !this.messages.isEmpty();
  }
  
  public String getStatus() {
    return this.status;
  }
  
  public A withStatus(String status) {
    this.status = status;
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AdminPolicyBasedRouteStatusFluent that = (AdminPolicyBasedRouteStatusFluent) o;
    if (!java.util.Objects.equals(lastTransitionTime, that.lastTransitionTime)) return false;
    if (!java.util.Objects.equals(messages, that.messages)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(lastTransitionTime,  messages,  status,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (lastTransitionTime != null) { sb.append("lastTransitionTime:"); sb.append(lastTransitionTime + ","); }
    if (messages != null && !messages.isEmpty()) { sb.append("messages:"); sb.append(messages + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}