/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.openclustermanagement.client.NamespacedOpenClusterManagementClient;
import io.fabric8.openclustermanagement.client.OpenClusterManagementClient;
import io.fabric8.openclustermanagement.server.mock.EnableOpenClusterManagementMockClient;
import io.fabric8.openclustermanagement.server.mock.OpenClusterManagementMockServer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class OpenClusterManagementMockServerExtension
extends KubernetesMockServerExtension {
    private OpenClusterManagementMockServer openClusterManagementMockServer;
    private NamespacedOpenClusterManagementClient openClusterManagementClient;

    protected void destroy() {
        this.openClusterManagementMockServer.destroy();
        this.openClusterManagementClient.close();
    }

    protected Class<?> getClientType() {
        return OpenClusterManagementClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return OpenClusterManagementMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableOpenClusterManagementMockClient a = testClass.getAnnotation(EnableOpenClusterManagementMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.openClusterManagementMockServer = a.crud() ? new OpenClusterManagementMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), a.https()) : new OpenClusterManagementMockServer(a.https());
        this.openClusterManagementMockServer.init();
        this.openClusterManagementClient = this.openClusterManagementMockServer.createOpenClusterManagement();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.openClusterManagementClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.openClusterManagementMockServer));
    }
}

