/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.openclustermanagement.client.OpenClusterManagementClient;
import io.fabric8.openclustermanagement.server.mock.OpenClusterManagementMockServer;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.rules.ExternalResource;

public class OpenClusterManagementServer
extends ExternalResource {
    protected OpenClusterManagementMockServer mock;
    private OpenClusterManagementClient client;
    private final boolean https;
    private final boolean crudMode;

    public OpenClusterManagementServer() {
        this(true, false);
    }

    public OpenClusterManagementServer(boolean https) {
        this(https, false);
    }

    public OpenClusterManagementServer(boolean https, boolean crudMode) {
        this.https = https;
        this.crudMode = crudMode;
    }

    public void before() {
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.mock = this.crudMode ? new OpenClusterManagementMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), true) : new OpenClusterManagementMockServer(this.https);
        this.mock.init();
        this.client = this.mock.createOpenClusterManagement();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public OpenClusterManagementClient get() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }
}

