package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PodResourceFluent<A extends PodResourceFluent<A>> extends BaseFluent<A>{
  public PodResourceFluent() {
  }
  
  public PodResourceFluent(PodResource instance) {
    this.copyInstance(instance);
  }
  private String limitCpu;
  private String limitMemory;
  private String requestCpu;
  private String requestMemory;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PodResource instance) {
    instance = (instance != null ? instance : new PodResource());
    if (instance != null) {
          this.withLimitCpu(instance.getLimitCpu());
          this.withLimitMemory(instance.getLimitMemory());
          this.withRequestCpu(instance.getRequestCpu());
          this.withRequestMemory(instance.getRequestMemory());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getLimitCpu() {
    return this.limitCpu;
  }
  
  public A withLimitCpu(String limitCpu) {
    this.limitCpu = limitCpu;
    return (A) this;
  }
  
  public boolean hasLimitCpu() {
    return this.limitCpu != null;
  }
  
  public String getLimitMemory() {
    return this.limitMemory;
  }
  
  public A withLimitMemory(String limitMemory) {
    this.limitMemory = limitMemory;
    return (A) this;
  }
  
  public boolean hasLimitMemory() {
    return this.limitMemory != null;
  }
  
  public String getRequestCpu() {
    return this.requestCpu;
  }
  
  public A withRequestCpu(String requestCpu) {
    this.requestCpu = requestCpu;
    return (A) this;
  }
  
  public boolean hasRequestCpu() {
    return this.requestCpu != null;
  }
  
  public String getRequestMemory() {
    return this.requestMemory;
  }
  
  public A withRequestMemory(String requestMemory) {
    this.requestMemory = requestMemory;
    return (A) this;
  }
  
  public boolean hasRequestMemory() {
    return this.requestMemory != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodResourceFluent that = (PodResourceFluent) o;
    if (!java.util.Objects.equals(limitCpu, that.limitCpu)) return false;
    if (!java.util.Objects.equals(limitMemory, that.limitMemory)) return false;
    if (!java.util.Objects.equals(requestCpu, that.requestCpu)) return false;
    if (!java.util.Objects.equals(requestMemory, that.requestMemory)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(limitCpu,  limitMemory,  requestCpu,  requestMemory,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (limitCpu != null) { sb.append("limitCpu:"); sb.append(limitCpu + ","); }
    if (limitMemory != null) { sb.append("limitMemory:"); sb.append(limitMemory + ","); }
    if (requestCpu != null) { sb.append("requestCpu:"); sb.append(requestCpu + ","); }
    if (requestMemory != null) { sb.append("requestMemory:"); sb.append(requestMemory + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}