package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageOverridesBuilder extends ImageOverridesFluent<ImageOverridesBuilder> implements VisitableBuilder<ImageOverrides,ImageOverridesBuilder>{
  public ImageOverridesBuilder() {
    this(new ImageOverrides());
  }
  
  public ImageOverridesBuilder(ImageOverridesFluent<?> fluent) {
    this(fluent, new ImageOverrides());
  }
  
  public ImageOverridesBuilder(ImageOverridesFluent<?> fluent,ImageOverrides instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageOverridesBuilder(ImageOverrides instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageOverridesFluent<?> fluent;
  
  public ImageOverrides build() {
    ImageOverrides buildable = new ImageOverrides(fluent.getRedisgraphTls(),fluent.getSearchAggregator(),fluent.getSearchApi(),fluent.getSearchCollector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}